/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sfee;

import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.model.Project;
import hudson.plugins.sfee.SourceForgeProject;
import hudson.plugins.sfee.SourceForgeSite;
import hudson.plugins.sfee.webservice.FolderSoapRow;
import hudson.plugins.sfee.webservice.InvalidSessionFault;
import hudson.plugins.sfee.webservice.NoSuchObjectFault;
import hudson.plugins.sfee.webservice.PermissionDeniedFault;
import hudson.plugins.sfee.webservice.SystemFault;
import hudson.plugins.sfee.webservice.TrackerSoapRow;
import hudson.util.ListBoxModel;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class SourceForgeProject
extends JobProperty<AbstractProject<?, ?>> {
    private final String projectId;
    private final String trackerId;
    private final String releasePackageId;
    public static final String NONE = "(none)";

    public String getTrackerId() {
        return this.trackerId;
    }

    @DataBoundConstructor
    public SourceForgeProject(String projectId, String releasePackageId, String trackerId) {
        this.projectId = projectId;
        this.trackerId = trackerId;
        this.releasePackageId = releasePackageId;
    }

    public JobPropertyDescriptor getDescriptor() {
        return DescriptorImpl.INSTANCE;
    }

    public static SourceForgeProject getProperty(AbstractProject<?, ?> project) {
        return (SourceForgeProject)project.getProperty(SourceForgeProject.class);
    }

    public static List<Project<?, ?>> getProjects(String projectId) {
        ArrayList result = new ArrayList();
        for (Project project : Hudson.getInstance().getProjects()) {
            SourceForgeProject p = SourceForgeProject.getProperty((AbstractProject)project);
            if (p == null || !projectId.equals(p.getProjectId())) continue;
            result.add(project);
        }
        return result;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public TrackerSoapRow[] getTrackers() throws NoSuchObjectFault, InvalidSessionFault, SystemFault, PermissionDeniedFault, RemoteException {
        SourceForgeSite site = SourceForgeSite.DESCRIPTOR.getSite();
        TrackerSoapRow[] trackers = site.getTrackers(this.projectId);
        return trackers;
    }

    private static Collection<ListBoxModel.Option> getTitles(FolderSoapRow[] folders) {
        HashSet<ListBoxModel.Option> result = new HashSet<ListBoxModel.Option>();
        for (FolderSoapRow psr : folders) {
            result.add(new ListBoxModel.Option(psr.getTitle(), psr.getId()));
        }
        return result;
    }

    public String getReleasePackageId() {
        return this.releasePackageId;
    }

    static /* synthetic */ Collection access$000(FolderSoapRow[] x0) {
        return SourceForgeProject.getTitles((FolderSoapRow[])x0);
    }
}

