/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sfee;

import hudson.plugins.sfee.Computable;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Memoizer<A, V>
implements Computable<A, V> {
    private final ConcurrentMap<A, ExpiringFutureTask<V>> cache = new ConcurrentHashMap<A, ExpiringFutureTask<V>>();
    private final Computable<A, V> c;

    public Memoizer(Computable<A, V> c) {
        this.c = c;
    }

    @Override
    public V compute(final A arg) throws InterruptedException {
        while (true) {
            Callable eval;
            ExpiringFutureTask ft;
            ExpiringFutureTask f;
            if ((f = (ExpiringFutureTask)this.cache.get(arg)) != null && f.hasExpired()) {
                this.cache.remove(arg);
                f = null;
            }
            if (f == null && (f = this.cache.putIfAbsent(arg, ft = new ExpiringFutureTask(eval = new Callable<V>(){

                @Override
                public V call() throws InterruptedException {
                    return Memoizer.this.c.compute(arg);
                }
            }))) == null) {
                f = ft;
                ft.run();
            }
            try {
                return f.get();
            }
            catch (CancellationException e) {
                this.cache.remove(arg, f);
                continue;
            }
            catch (ExecutionException e) {
                try {
                    this.cache.remove(arg, f);
                    throw e.getCause();
                }
                catch (RuntimeException ex) {
                    throw ex;
                }
                catch (Error ex) {
                    throw ex;
                }
                catch (Throwable t) {
                    throw new IllegalStateException("Not unchecked", t);
                }
            }
            break;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExpiringFutureTask<V>
    extends FutureTask<V> {
        private long creationTime = System.currentTimeMillis();

        public ExpiringFutureTask(Callable<V> callable) {
            super(callable);
        }

        public boolean hasExpired() {
            return System.currentTimeMillis() - this.creationTime > 60000L;
        }
    }
}

