/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sfee;

import hudson.Plugin;
import hudson.model.Jobs;
import hudson.model.Run;
import hudson.plugins.sfee.LinkAnnotator;
import hudson.plugins.sfee.Messages;
import hudson.plugins.sfee.SFEEMailAddressResolver;
import hudson.plugins.sfee.SFEEReleasePublisher;
import hudson.plugins.sfee.SFEESecurityRealm;
import hudson.plugins.sfee.SourceForgeProject;
import hudson.plugins.sfee.SourceForgeSite;
import hudson.plugins.sfee.webservice.PackageSoapRow;
import hudson.security.Permission;
import hudson.security.SecurityRealm;
import hudson.tasks.BuildStep;
import hudson.tasks.MailAddressResolver;
import hudson.tasks.UserNameResolver;
import hudson.util.ListBoxModel;
import java.io.IOException;
import javax.servlet.ServletException;
import org.codehaus.plexus.util.StringUtils;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class PluginImpl
extends Plugin {
    private LinkAnnotator annotator = new LinkAnnotator();
    public static Permission PUBLISH = new Permission(Run.PERMISSIONS, Messages.Run_Permissions_Publish(), Messages._Run_PublishPermission_Description(), Permission.FULL_CONTROL);

    public void start() throws Exception {
        Jobs.PROPERTIES.add(SourceForgeProject.DescriptorImpl.INSTANCE);
        Jobs.PROPERTIES.add(SourceForgeSite.DESCRIPTOR);
        SecurityRealm.LIST.add((Object)SFEESecurityRealm.DESCRIPTOR);
        SFEEMailAddressResolver resolver = new SFEEMailAddressResolver();
        MailAddressResolver.LIST.add(resolver.getMailAddressResolver());
        UserNameResolver.LIST.add(resolver.getUserNameResolver());
        this.annotator.register();
        BuildStep.PUBLISHERS.add((Object)SFEEReleasePublisher.DescriptorImpl.INSTANCE);
    }

    public void stop() {
        this.annotator.unregister();
    }

    public void doGetReleasePackages(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="projectId") String projectId) throws IOException, ServletException {
        ListBoxModel r = new ListBoxModel();
        if (!StringUtils.isEmpty((String)projectId) && !projectId.equals("<none>")) {
            PackageSoapRow[] releasePackages;
            SourceForgeSite site = SourceForgeSite.DESCRIPTOR.getSite();
            for (PackageSoapRow row : releasePackages = site.getReleasePackages(projectId)) {
                r.add((Object)new ListBoxModel.Option(row.getTitle(), row.getId()));
            }
        }
        r.writeTo(req, rsp);
    }
}

