/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sfee;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.plugins.descriptionsetter.DescriptionSetterAction;
import hudson.plugins.sfee.SFEEReleasePublisher;
import hudson.plugins.sfee.SFEEReleaseTask;
import hudson.plugins.sfee.SourceForgeProject;
import hudson.tasks.Publisher;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SFEEReleasePublisher
extends Publisher {
    private static final String REGEXP = ".*\\[INFO\\] Uploading project information for [^\\s]* ([^\\s]*)";
    private final String releaseToReplace;
    private final boolean uploadArtifacts = true;
    private final String maturity;
    private final boolean uploadAutomatically;
    private final boolean replaceArtifacts;
    private final String sourceRegexp;
    private final String releaseName;

    @DataBoundConstructor
    public SFEEReleasePublisher(String sourceRegexp, String releaseName, String releaseToReplace, String maturity, boolean replaceArtifacts, boolean uploadAutomatically) {
        this.releaseToReplace = StringUtils.isBlank((String)releaseToReplace) ? null : releaseToReplace.trim();
        this.replaceArtifacts = replaceArtifacts;
        this.maturity = maturity;
        this.uploadAutomatically = uploadAutomatically;
        this.sourceRegexp = sourceRegexp;
        this.releaseName = releaseName;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        String version = this.getVersion(build);
        if (version == null) {
            listener.fatalError("SFEE Publisher: Could not find version in build log.");
            return false;
        }
        SourceForgeProject project = (SourceForgeProject)build.getProject().getProperty(SourceForgeProject.class);
        String releasePackageId = project.getReleasePackageId();
        if (releasePackageId == null) {
            listener.fatalError("SFEE Publisher: No release package set");
            return false;
        }
        SFEEReleaseTask newReleaseTask = new SFEEReleaseTask(build, releasePackageId, version, this.releaseToReplace, this.maturity, true, this.replaceArtifacts);
        build.addAction((Action)newReleaseTask);
        if (this.uploadAutomatically) {
            newReleaseTask.startUpload();
        }
        return true;
    }

    private String getVersion(AbstractBuild<?, ?> build) throws FileNotFoundException, IOException {
        String line;
        DescriptionSetterAction description = (DescriptionSetterAction)build.getAction(DescriptionSetterAction.class);
        if (description != null) {
            return description.getDescription();
        }
        Pattern pattern = Pattern.compile(this.sourceRegexp);
        BufferedReader reader = new BufferedReader(new FileReader(build.getLogFile()));
        while ((line = reader.readLine()) != null) {
            Matcher matcher = pattern.matcher(line);
            if (!matcher.matches()) continue;
            String result = this.releaseName;
            for (int i = 0; i <= matcher.groupCount(); ++i) {
                result = result.replace("\\" + i, matcher.group(i));
            }
            return result;
        }
        return null;
    }

    public Descriptor<Publisher> getDescriptor() {
        return DescriptorImpl.INSTANCE;
    }

    public String getReleaseToReplace() {
        return this.releaseToReplace;
    }

    public boolean isUploadArtifacts() {
        return true;
    }

    public boolean isReplaceArtifacts() {
        return this.replaceArtifacts;
    }

    public String getMaturity() {
        return this.maturity;
    }

    public boolean isUploadAutomatically() {
        return this.uploadAutomatically;
    }

    public String getSourceRegexp() {
        return this.sourceRegexp;
    }

    public String getReleaseName() {
        return this.releaseName;
    }
}

