/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sfee;

import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Job;
import hudson.plugins.sfee.SourceForgeProject;
import hudson.security.ACL;
import hudson.security.AuthorizationStrategy;
import hudson.security.FullControlOnceLoggedInAuthorizationStrategy;
import hudson.security.SparseACL;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.acls.sid.GrantedAuthoritySid;
import org.acegisecurity.acls.sid.Sid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SFEEProjectBasedAuthorizationStrategy
extends FullControlOnceLoggedInAuthorizationStrategy {
    public static final SparseACL UNSECURED_PROJECT_ACL = new SparseACL(null);
    public static final Descriptor<AuthorizationStrategy> DESCRIPTOR;

    public ACL getRootACL() {
        return UNSECURED_PROJECT_ACL;
    }

    public GrantedAuthority createAuthority(Job<?, ?> project) {
        SourceForgeProject p = (SourceForgeProject)project.getProperty(SourceForgeProject.class);
        if (p != null) {
            return new GrantedAuthorityImpl(p.getProjectId());
        }
        return null;
    }

    public ACL getACL(Job<?, ?> project) {
        GrantedAuthority auth = this.createAuthority(project);
        if (auth != null) {
            SparseACL acl = new SparseACL(this.getRootACL());
            acl.add((Sid)new GrantedAuthoritySid(auth), Hudson.ADMINISTER, true);
            return acl;
        }
        return UNSECURED_PROJECT_ACL;
    }

    public Descriptor<AuthorizationStrategy> getDescriptor() {
        return DESCRIPTOR;
    }

    static {
        UNSECURED_PROJECT_ACL.add(ACL.ANONYMOUS, Hudson.ADMINISTER, false);
        UNSECURED_PROJECT_ACL.add(ACL.EVERYONE, Hudson.ADMINISTER, true);
        DESCRIPTOR = new /* Unavailable Anonymous Inner Class!! */;
    }
}

