/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sfee;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskAction;
import hudson.model.TaskListener;
import hudson.plugins.sfee.PluginImpl;
import hudson.plugins.sfee.SFEEReleaseTask;
import hudson.plugins.sfee.SourceForgeProject;
import hudson.plugins.sfee.SourceForgeSite;
import hudson.plugins.sfee.TrackerArtifact;
import hudson.plugins.sfee.webservice.ArtifactDetailSoapRow;
import hudson.plugins.sfee.webservice.InvalidFilterFault;
import hudson.plugins.sfee.webservice.InvalidSessionFault;
import hudson.plugins.sfee.webservice.NoSuchObjectFault;
import hudson.plugins.sfee.webservice.PermissionDeniedFault;
import hudson.plugins.sfee.webservice.SystemFault;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.security.Permission;
import hudson.widgets.HistoryWidget;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.ServletException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SFEEReleaseTask<T extends AbstractBuild>
extends TaskAction
implements AccessControlled {
    private final AbstractBuild<?, ?> build;
    private final String releasePackageId;
    private final String releaseName;
    private final String maturity;
    private final String releaseToReplace;
    private List<TrackerArtifact> resolvedTrackerArtifacts;
    private final boolean uploadFiles;
    private final boolean replaceFiles;
    private boolean uploadBuildLog;
    private Map<String, Boolean> downloadingArtifactList = null;
    public final CopyOnWriteArrayList<Record> records = new CopyOnWriteArrayList();
    protected String fileReleaseId;
    private static final HistoryWidget.Adapter<Record> ADAPTER = new /* Unavailable Anonymous Inner Class!! */;

    public SFEEReleaseTask(AbstractBuild<?, ?> build, String releasePackageId, String releaseName, String releaseToReplace, String maturity, boolean uploadFiles, boolean replaceFiles) {
        this.build = build;
        this.releasePackageId = releasePackageId;
        this.releaseName = releaseName;
        this.releaseToReplace = releaseToReplace;
        this.maturity = maturity;
        this.uploadFiles = uploadFiles;
        this.replaceFiles = replaceFiles;
    }

    public ACL getACL() {
        return this.build.getACL();
    }

    protected Permission getPermission() {
        return PluginImpl.PUBLISH;
    }

    public String getDisplayName() {
        if (this.hasPermission(this.getPermission())) {
            return "SourceForge";
        }
        return null;
    }

    public String getIconFileName() {
        if (this.hasPermission(this.getPermission())) {
            return this.isCompleted() ? "star-gold.gif" : "star.gif";
        }
        return null;
    }

    public String getUrlName() {
        if (this.hasPermission(this.getPermission())) {
            return "upload";
        }
        return null;
    }

    public boolean isCompleted() {
        return this.records.size() > 0 && ((Record)this.records.get(this.records.size() - 1)).getResult() == Result.SUCCESS;
    }

    public HistoryWidgetImpl getHistoryWidget() {
        return new HistoryWidgetImpl(this, null);
    }

    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) {
        if ("buildHistory".equals(token)) {
            return this.getHistoryWidget();
        }
        if ("buildTimeTrend".equals(token)) {
            return null;
        }
        return this.records.get(Integer.valueOf(token));
    }

    public final void doUpload(StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException {
        this.getACL().checkPermission(this.getPermission());
        this.uploadBuildLog = "on".equals(req.getParameter("uploadBuildLog"));
        boolean doUpload = false;
        List buildArtifacts = this.build.getArtifacts();
        for (Run.Artifact buildArtifact : buildArtifacts) {
            doUpload = "on".equals(req.getParameter(buildArtifact.getFileName()));
            this.getDownloadingArtifactList().put(buildArtifact.getFileName(), doUpload);
        }
        this.startUpload();
        rsp.sendRedirect(".");
    }

    public void startUpload() throws IOException {
        File logFile = new File(this.build.getRootDir(), "sfee-upload." + this.records.size() + ".log");
        Record record = new Record(this, logFile.getName());
        this.records.add(record);
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public static String createOrUpdateRelease(TaskListener listener, String releaseName, String releaseToReplace, String packageId, String maturity) throws NoSuchObjectFault, InvalidSessionFault, SystemFault, PermissionDeniedFault, RemoteException {
        SourceForgeSite site = SourceForgeSite.DESCRIPTOR.getSite();
        String releaseId = null;
        if (releaseToReplace != null) {
            listener.getLogger().printf("Update release from '%s' to '%s'\n...", releaseToReplace, releaseName);
            releaseId = site.updateReleaseName(packageId, releaseToReplace, releaseName);
            if (releaseId == null) {
                listener.fatalError("No release found with name " + releaseToReplace);
                return null;
            }
            listener.getLogger().printf("Creating new release '%s'\n", releaseToReplace);
            site.createRelease(packageId, releaseToReplace, "", "active", maturity);
        } else {
            listener.getLogger().printf("Checking for existing release\n", releaseName);
            releaseId = site.getReleaseId(packageId, releaseName);
            if (releaseId == null) {
                listener.getLogger().printf("Creating new release '%s'\n", releaseName);
                releaseId = site.createRelease(packageId, releaseName, "", "active", maturity);
            }
        }
        return releaseId;
    }

    private List<TrackerArtifact> findResolvedArtifacts(AbstractProject<?, ?> p, String releaseName) throws InvalidFilterFault, NoSuchObjectFault, InvalidSessionFault, SystemFault, PermissionDeniedFault, RemoteException {
        SourceForgeProject project = SourceForgeProject.getProperty(p);
        SourceForgeSite site = SourceForgeSite.DESCRIPTOR.getSite();
        List findArtifactsResolvedInRelease = site.findArtifactsResolvedInRelease(releaseName, project.getProjectId());
        ArrayList<TrackerArtifact> trackerArtifacts = new ArrayList<TrackerArtifact>();
        for (ArtifactDetailSoapRow r : findArtifactsResolvedInRelease) {
            System.out.println("Adding new TrackerArtifact");
            trackerArtifacts.add(new TrackerArtifact(r));
        }
        System.out.println("TrackerArtifact size: " + trackerArtifacts.size());
        return trackerArtifacts;
    }

    public AbstractBuild<?, ?> getBuild() {
        return this.build;
    }

    public String getReleasePackageId() {
        return this.releasePackageId;
    }

    public String getReleaseName() {
        return this.releaseName;
    }

    public String getMaturity() {
        return this.maturity;
    }

    public String getReleaseToReplace() {
        return this.releaseToReplace;
    }

    public List<TrackerArtifact> getResolvedTrackerArtifacts() {
        try {
            this.resolvedTrackerArtifacts = this.findResolvedArtifacts(this.build.getProject(), this.releaseName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.resolvedTrackerArtifacts;
    }

    public boolean isUploadFiles() {
        return this.uploadFiles;
    }

    public boolean isReplaceFiles() {
        return this.replaceFiles;
    }

    public CopyOnWriteArrayList<Record> getRecords() {
        return this.records;
    }

    public Object getFileReleaseId() {
        return this.fileReleaseId;
    }

    public String getFileReleaseUrl() {
        return this.fileReleaseId != null ? SourceForgeSite.DESCRIPTOR.getSite().getURL(this.fileReleaseId) : null;
    }

    public boolean isUploadBuildLog() {
        return this.uploadBuildLog;
    }

    public void setUploadBuildLog(boolean uploadBuildLog) {
        this.uploadBuildLog = uploadBuildLog;
    }

    public void doStop(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (this.workerThread != null) {
            this.workerThread.interrupt();
        }
        rsp.sendRedirect(".");
    }

    protected void onComplete() {
    }

    public void setDownloadingArtifactList(Map<String, Boolean> downloadingArtifactList) {
        this.downloadingArtifactList = downloadingArtifactList;
    }

    public Map<String, Boolean> getDownloadingArtifactList() {
        if (this.downloadingArtifactList == null) {
            this.downloadingArtifactList = new HashMap();
            List buildArtifacts = this.build.getArtifacts();
            for (Run.Artifact buildArtifact : buildArtifacts) {
                System.out.println("Adding new artifact: " + buildArtifact.getFileName());
                this.downloadingArtifactList.put(buildArtifact.getFileName(), Boolean.TRUE);
            }
        }
        return this.downloadingArtifactList;
    }

    public void checkPermission(Permission permission) {
        this.getACL().checkPermission(permission);
    }

    public boolean hasPermission(Permission permission) {
        return this.getACL().hasPermission(permission);
    }

    static /* synthetic */ HistoryWidget.Adapter access$100() {
        return ADAPTER;
    }

    static /* synthetic */ String access$200(SFEEReleaseTask x0) {
        return x0.releaseName;
    }

    static /* synthetic */ String access$300(SFEEReleaseTask x0) {
        return x0.releaseToReplace;
    }

    static /* synthetic */ String access$400(SFEEReleaseTask x0) {
        return x0.releasePackageId;
    }

    static /* synthetic */ String access$500(SFEEReleaseTask x0) {
        return x0.maturity;
    }

    static /* synthetic */ AbstractBuild access$700(SFEEReleaseTask x0) {
        return x0.build;
    }

    static /* synthetic */ List access$802(SFEEReleaseTask x0, List x1) {
        x0.resolvedTrackerArtifacts = x1;
        return x0.resolvedTrackerArtifacts;
    }

    static /* synthetic */ List access$900(SFEEReleaseTask x0, AbstractProject x1, String x2) throws InvalidFilterFault, NoSuchObjectFault, InvalidSessionFault, SystemFault, PermissionDeniedFault, RemoteException {
        return x0.findResolvedArtifacts(x1, x2);
    }
}

