/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sfee;

import hudson.plugins.sfee.SFEESecurityRealm;
import hudson.plugins.sfee.SourceForgeSite;
import hudson.plugins.sfee.webservice.ProjectSoapRow;
import hudson.plugins.sfee.webservice.UserSoapDO;
import java.util.HashSet;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.userdetails.User;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataRetrievalFailureException;

public class SFEEUserDetailsService
implements UserDetailsService {
    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        SourceForgeSite site = SourceForgeSite.DESCRIPTOR.getSite();
        HashSet<GrantedAuthorityImpl> authorities = new HashSet<GrantedAuthorityImpl>();
        authorities.add(new GrantedAuthorityImpl("authenticated"));
        String password = SFEESecurityRealm.DESCRIPTOR.getPassword(username);
        if (password == null) {
            throw new UsernameNotFoundException("Password not known for this user - please login");
        }
        try {
            ProjectSoapRow[] projects;
            String sessionId = site.createSession(username, password);
            UserSoapDO userDetails = site.getUserDetails(username);
            if (userDetails.isSuperUser()) {
                authorities.add(new GrantedAuthorityImpl("admin"));
            }
            for (ProjectSoapRow project : projects = site.getProjects(sessionId)) {
                authorities.add(new GrantedAuthorityImpl(project.getId()));
            }
            GrantedAuthority[] authoritiesArray = authorities.toArray(new GrantedAuthority[authorities.size()]);
            return new User(username, password, true, true, true, true, authoritiesArray);
        }
        catch (BadCredentialsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataRetrievalFailureException("SFEE error", (Throwable)e);
        }
    }
}

