/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sfee;

import hudson.MarkupText;
import hudson.model.AbstractBuild;
import hudson.plugins.sfee.SourceForgeSite;
import hudson.scm.ChangeLogAnnotator;
import hudson.scm.ChangeLogSet;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkAnnotator
extends ChangeLogAnnotator {
    static final LinkMarkup[] MARKUPS = new LinkMarkup[]{new LinkMarkup("(artf|task|rel)NUM", "$1$2")};

    public void annotate(AbstractBuild<?, ?> build, ChangeLogSet.Entry change, MarkupText text) {
        String site = this.getServer();
        if (site == null) {
            return;
        }
        String url = "http://" + this.getServer() + "/sf/go/";
        for (LinkMarkup markup : MARKUPS) {
            markup.process(text, url);
        }
    }

    private String getServer() {
        SourceForgeSite site = SourceForgeSite.DESCRIPTOR.getSite();
        return site != null ? site.getSite() : null;
    }

    static final class LinkMarkup {
        private final Pattern pattern;
        private final String href;
        private static final Pattern NUM_PATTERN = Pattern.compile("NUM");
        private static final Pattern ANYWORD_PATTERN = Pattern.compile("ANYWORD");

        LinkMarkup(String pattern, String href) {
            pattern = NUM_PATTERN.matcher(pattern).replaceAll("(\\\\d+)");
            pattern = ANYWORD_PATTERN.matcher(pattern).replaceAll("((?:\\\\w|[._-])+)");
            this.pattern = Pattern.compile(pattern);
            this.href = href;
        }

        void process(MarkupText text, String url) {
            for (MarkupText.SubText st : text.findTokens(this.pattern)) {
                st.surroundWith("<a href='" + url + this.href + "'>", "</a>");
            }
        }
    }
}

