/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sfee;

import hudson.model.User;
import hudson.plugins.sfee.SourceForgeSite;
import hudson.plugins.sfee.webservice.UserSoapRow;
import hudson.tasks.MailAddressResolver;
import hudson.tasks.UserNameResolver;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SFEEMailAddressResolver {
    private static SFEEMailAddressResolver INSTANCE = new SFEEMailAddressResolver();
    private static Logger log = Logger.getLogger(SFEEMailAddressResolver.class.getName());
    private static String UNKNOWN = "unknown";
    private final Map<String, String> emails = new HashMap<String, String>();
    private final Map<String, String> names = new HashMap<String, String>();
    private final MailAddressResolver mailAddressResolver = new MailAddressResolver(){

        public synchronized String findMailAddressFor(User u) {
            String result = (String)SFEEMailAddressResolver.this.emails.get(u.getId());
            if (result == null) {
                SFEEMailAddressResolver.this.update();
                result = (String)SFEEMailAddressResolver.this.emails.get(u.getId());
                if (result == null) {
                    SFEEMailAddressResolver.this.emails.put(u.getId(), UNKNOWN);
                }
            }
            if (UNKNOWN.equals(result)) {
                return null;
            }
            return result;
        }
    };
    private final UserNameResolver userNameResolver = new UserNameResolver(){

        public synchronized String findNameFor(User u) {
            String result = (String)SFEEMailAddressResolver.this.names.get(u.getId());
            if (result == null) {
                SFEEMailAddressResolver.this.update();
                result = (String)SFEEMailAddressResolver.this.names.get(u.getId());
                if (result == null) {
                    SFEEMailAddressResolver.this.names.put(u.getId(), UNKNOWN);
                }
            }
            if (UNKNOWN.equals(result)) {
                return null;
            }
            return result;
        }
    };

    public SFEEMailAddressResolver() {
        this.update();
    }

    private void update() {
        try {
            SourceForgeSite site = SourceForgeSite.DESCRIPTOR.getSite();
            if (site != null) {
                UserSoapRow[] users;
                for (UserSoapRow user : users = site.getUsers()) {
                    this.emails.put(user.getUserName(), user.getEmail());
                    this.names.put(user.getUserName(), user.getFullName());
                }
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Error getting users", e);
        }
    }

    public static MailAddressResolver getMailAddressResolver() {
        return SFEEMailAddressResolver.INSTANCE.mailAddressResolver;
    }

    public static UserNameResolver getUserNameResolver() {
        return SFEEMailAddressResolver.INSTANCE.userNameResolver;
    }
}

