/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sfee;

import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BallColor;
import hudson.model.ModelObject;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskAction;
import hudson.model.TaskListener;
import hudson.model.TaskThread;
import hudson.plugins.sfee.PluginImpl;
import hudson.plugins.sfee.SFEEReleaseCompletedTask;
import hudson.plugins.sfee.SourceForgeProject;
import hudson.plugins.sfee.SourceForgeSite;
import hudson.plugins.sfee.TrackerArtifact;
import hudson.plugins.sfee.webservice.ArtifactDetailSoapRow;
import hudson.plugins.sfee.webservice.InvalidFilterFault;
import hudson.plugins.sfee.webservice.InvalidSessionFault;
import hudson.plugins.sfee.webservice.NoSuchObjectFault;
import hudson.plugins.sfee.webservice.PermissionDeniedFault;
import hudson.plugins.sfee.webservice.SystemFault;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.security.Permission;
import hudson.util.Iterators;
import hudson.widgets.HistoryWidget;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.servlet.ServletException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.framework.io.LargeText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SFEEReleaseTask<T extends AbstractBuild>
extends TaskAction
implements AccessControlled {
    private final AbstractBuild<?, ?> build;
    private final String releasePackageId;
    private final String releaseName;
    private final String maturity;
    private final String releaseToReplace;
    private List<TrackerArtifact> resolvedTrackerArtifacts;
    private final boolean uploadFiles;
    private final boolean replaceFiles;
    private boolean uploadBuildLog;
    private Map<String, Boolean> downloadingArtifactList = null;
    public final CopyOnWriteArrayList<Record> records = new CopyOnWriteArrayList();
    protected String fileReleaseId;
    private static final HistoryWidget.Adapter<Record> ADAPTER = new HistoryWidget.Adapter<Record>(){

        public int compare(Record record, String key) {
            return record.getNumber() - Integer.parseInt(key);
        }

        public String getKey(Record record) {
            return String.valueOf(record.getNumber());
        }

        public boolean isBuilding(Record record) {
            return record.isBuilding();
        }

        public String getNextKey(String key) {
            return String.valueOf(Integer.parseInt(key) + 1);
        }
    };

    public SFEEReleaseTask(AbstractBuild<?, ?> build, String releasePackageId, String releaseName, String releaseToReplace, String maturity, boolean uploadFiles, boolean replaceFiles) {
        this.build = build;
        this.releasePackageId = releasePackageId;
        this.releaseName = releaseName;
        this.releaseToReplace = releaseToReplace;
        this.maturity = maturity;
        this.uploadFiles = uploadFiles;
        this.replaceFiles = replaceFiles;
    }

    public ACL getACL() {
        return this.build.getACL();
    }

    protected Permission getPermission() {
        return PluginImpl.PUBLISH;
    }

    public String getDisplayName() {
        if (this.hasPermission(this.getPermission())) {
            return "SourceForge";
        }
        return null;
    }

    public String getIconFileName() {
        if (this.hasPermission(this.getPermission())) {
            return this.isCompleted() ? "star-gold.gif" : "star.gif";
        }
        return null;
    }

    public String getUrlName() {
        if (this.hasPermission(this.getPermission())) {
            return "upload";
        }
        return null;
    }

    public boolean isCompleted() {
        return this.records.size() > 0 && this.records.get(this.records.size() - 1).getResult() == Result.SUCCESS;
    }

    public HistoryWidgetImpl getHistoryWidget() {
        return new HistoryWidgetImpl();
    }

    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) {
        if ("buildHistory".equals(token)) {
            return this.getHistoryWidget();
        }
        if ("buildTimeTrend".equals(token)) {
            return null;
        }
        return this.records.get(Integer.valueOf(token));
    }

    public final void doUpload(StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException {
        this.getACL().checkPermission(this.getPermission());
        this.uploadBuildLog = "on".equals(req.getParameter("uploadBuildLog"));
        boolean doUpload = false;
        List buildArtifacts = this.build.getArtifacts();
        for (Run.Artifact buildArtifact : buildArtifacts) {
            doUpload = "on".equals(req.getParameter(buildArtifact.getFileName()));
            this.getDownloadingArtifactList().put(buildArtifact.getFileName(), doUpload);
        }
        this.startUpload();
        rsp.sendRedirect(".");
    }

    public void startUpload() throws IOException {
        File logFile = new File(this.build.getRootDir(), "sfee-upload." + this.records.size() + ".log");
        final Record record = new Record(logFile.getName());
        this.records.add(record);
        new TaskThread(this, TaskThread.ListenerAndText.forFile((File)logFile)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void perform(TaskListener listener) throws Exception {
                try {
                    long start = System.currentTimeMillis();
                    SourceForgeSite site = SourceForgeSite.DESCRIPTOR.getSite();
                    if (SFEEReleaseTask.this.fileReleaseId == null) {
                        SFEEReleaseTask.this.fileReleaseId = SFEEReleaseTask.createOrUpdateRelease(listener, SFEEReleaseTask.this.releaseName, SFEEReleaseTask.this.releaseToReplace, SFEEReleaseTask.this.releasePackageId, SFEEReleaseTask.this.maturity);
                        if (SFEEReleaseTask.this.fileReleaseId == null) {
                            record.result = Result.FAILURE;
                            return;
                        }
                        if (SFEEReleaseTask.this.isUploadFiles()) {
                            listener.getLogger().println("Existing files will " + (SFEEReleaseTask.this.isReplaceFiles() ? "" : "not") + " be overwitten");
                            if (SFEEReleaseTask.this.isUploadBuildLog()) {
                                String logFileName = SFEEReleaseTask.this.releaseName + "-" + ((AbstractProject)SFEEReleaseTask.this.build.getParent()).getDisplayName() + "-" + SFEEReleaseTask.this.build.getNumber() + "-" + SFEEReleaseTask.this.build.getId() + ".log";
                                listener.getLogger().println("Uploading build log file " + logFileName + "...");
                                site.uploadFileForRelease(SFEEReleaseTask.this.fileReleaseId, logFileName, new DataHandler((DataSource)new FileDataSource(SFEEReleaseTask.this.build.getLogFile())), SFEEReleaseTask.this.isReplaceFiles());
                            }
                            List buildArtifacts = SFEEReleaseTask.this.build.getArtifacts();
                            for (Run.Artifact buildArtifact : buildArtifacts) {
                                if (SFEEReleaseTask.this.getDownloadingArtifactList().get(buildArtifact.getFileName()).booleanValue()) {
                                    listener.getLogger().print("Uploading file " + buildArtifact.getFileName() + " ...");
                                    site.uploadFileForRelease(SFEEReleaseTask.this.fileReleaseId, buildArtifact.getFileName(), buildArtifact.getFile().toURI().toURL(), SFEEReleaseTask.this.isReplaceFiles());
                                    listener.getLogger().println(" upload successfully completed!");
                                    continue;
                                }
                                listener.getLogger().println("Skipping unselected file " + buildArtifact.getFileName());
                            }
                        }
                    } else {
                        listener.getLogger().println("Reusing previous release " + SFEEReleaseTask.this.fileReleaseId);
                    }
                    SFEEReleaseTask.this.resolvedTrackerArtifacts = SFEEReleaseTask.this.findResolvedArtifacts(SFEEReleaseTask.this.build.getProject(), SFEEReleaseTask.this.releaseName);
                    long duration = System.currentTimeMillis() - start;
                    listener.getLogger().println("Total time: " + Util.getTimeSpanString((long)duration));
                    record.result = Result.SUCCESS;
                    SFEEReleaseTask.this.build.addAction((Action)new SFEEReleaseCompletedTask(SFEEReleaseTask.this));
                    SFEEReleaseTask.this.onComplete();
                }
                finally {
                    if (record.result == null) {
                        record.result = Result.FAILURE;
                    }
                    SFEEReleaseTask.this.build.save();
                }
            }
        }.start();
    }

    public static String createOrUpdateRelease(TaskListener listener, String releaseName, String releaseToReplace, String packageId, String maturity) throws NoSuchObjectFault, InvalidSessionFault, SystemFault, PermissionDeniedFault, RemoteException {
        SourceForgeSite site = SourceForgeSite.DESCRIPTOR.getSite();
        String releaseId = null;
        if (releaseToReplace != null) {
            listener.getLogger().printf("Update release from '%s' to '%s'\n...", releaseToReplace, releaseName);
            releaseId = site.updateReleaseName(packageId, releaseToReplace, releaseName);
            if (releaseId == null) {
                listener.fatalError("No release found with name " + releaseToReplace);
                return null;
            }
            listener.getLogger().printf("Creating new release '%s'\n", releaseToReplace);
            site.createRelease(packageId, releaseToReplace, "", "active", maturity);
        } else {
            listener.getLogger().printf("Checking for existing release\n", releaseName);
            releaseId = site.getReleaseId(packageId, releaseName);
            if (releaseId == null) {
                listener.getLogger().printf("Creating new release '%s'\n", releaseName);
                releaseId = site.createRelease(packageId, releaseName, "", "active", maturity);
            }
        }
        return releaseId;
    }

    private List<TrackerArtifact> findResolvedArtifacts(AbstractProject<?, ?> p, String releaseName) throws InvalidFilterFault, NoSuchObjectFault, InvalidSessionFault, SystemFault, PermissionDeniedFault, RemoteException {
        SourceForgeProject project = SourceForgeProject.getProperty(p);
        SourceForgeSite site = SourceForgeSite.DESCRIPTOR.getSite();
        List<ArtifactDetailSoapRow> findArtifactsResolvedInRelease = site.findArtifactsResolvedInRelease(releaseName, project.getProjectId());
        ArrayList<TrackerArtifact> trackerArtifacts = new ArrayList<TrackerArtifact>();
        for (ArtifactDetailSoapRow r : findArtifactsResolvedInRelease) {
            System.out.println("Adding new TrackerArtifact");
            trackerArtifacts.add(new TrackerArtifact(r));
        }
        System.out.println("TrackerArtifact size: " + trackerArtifacts.size());
        return trackerArtifacts;
    }

    public AbstractBuild<?, ?> getBuild() {
        return this.build;
    }

    public String getReleasePackageId() {
        return this.releasePackageId;
    }

    public String getReleaseName() {
        return this.releaseName;
    }

    public String getMaturity() {
        return this.maturity;
    }

    public String getReleaseToReplace() {
        return this.releaseToReplace;
    }

    public List<TrackerArtifact> getResolvedTrackerArtifacts() {
        try {
            this.resolvedTrackerArtifacts = this.findResolvedArtifacts(this.build.getProject(), this.releaseName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.resolvedTrackerArtifacts;
    }

    public boolean isUploadFiles() {
        return this.uploadFiles;
    }

    public boolean isReplaceFiles() {
        return this.replaceFiles;
    }

    public CopyOnWriteArrayList<Record> getRecords() {
        return this.records;
    }

    public Object getFileReleaseId() {
        return this.fileReleaseId;
    }

    public String getFileReleaseUrl() {
        return this.fileReleaseId != null ? SourceForgeSite.DESCRIPTOR.getSite().getURL(this.fileReleaseId) : null;
    }

    public boolean isUploadBuildLog() {
        return this.uploadBuildLog;
    }

    public void setUploadBuildLog(boolean uploadBuildLog) {
        this.uploadBuildLog = uploadBuildLog;
    }

    public void doStop(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (this.workerThread != null) {
            this.workerThread.interrupt();
        }
        rsp.sendRedirect(".");
    }

    protected void onComplete() {
    }

    public void setDownloadingArtifactList(Map<String, Boolean> downloadingArtifactList) {
        this.downloadingArtifactList = downloadingArtifactList;
    }

    public Map<String, Boolean> getDownloadingArtifactList() {
        if (this.downloadingArtifactList == null) {
            this.downloadingArtifactList = new HashMap<String, Boolean>();
            List buildArtifacts = this.build.getArtifacts();
            for (Run.Artifact buildArtifact : buildArtifacts) {
                System.out.println("Adding new artifact: " + buildArtifact.getFileName());
                this.downloadingArtifactList.put(buildArtifact.getFileName(), Boolean.TRUE);
            }
        }
        return this.downloadingArtifactList;
    }

    public void checkPermission(Permission permission) {
        this.getACL().checkPermission(permission);
    }

    public boolean hasPermission(Permission permission) {
        return this.getACL().hasPermission(permission);
    }

    public final class Record {
        private final String fileName;
        private Result result;
        private final Calendar timeStamp;
        private long duration;
        private long estimatedDuration;

        public Record(String fileName) {
            this.fileName = fileName;
            this.timeStamp = new GregorianCalendar();
        }

        public LargeText getLog() {
            return new LargeText(new File(SFEEReleaseTask.this.build.getRootDir(), this.fileName), true);
        }

        public Result getResult() {
            return this.result;
        }

        public int getNumber() {
            return SFEEReleaseTask.this.records.indexOf(this);
        }

        public boolean isBuilding() {
            return this.result == null;
        }

        public Calendar getTimestamp() {
            return (Calendar)this.timeStamp.clone();
        }

        public String getBuildStatusUrl() {
            return this.getIconColor().getImage();
        }

        public BallColor getIconColor() {
            if (this.result == null) {
                return BallColor.GREY_ANIME;
            }
            return this.result.color;
        }

        public final void doIndex(StaplerRequest req, StaplerResponse rsp) throws IOException {
            rsp.setContentType("text/plain;charset=UTF-8");
            this.getLog().writeLogTo(0L, (Writer)rsp.getWriter());
        }

        public void doStop(StaplerRequest req, StaplerResponse rsp) throws IOException {
            rsp.sendRedirect("../stop");
        }

        public String getTimestampString() {
            return Util.getTimeSpanString((long)this.duration);
        }

        public Object getExecutor() {
            return new Object(){

                public int getProgress() {
                    long d = Record.this.estimatedDuration;
                    if (d < 0L) {
                        return -1;
                    }
                    int num = (int)((System.currentTimeMillis() - Record.this.timeStamp.getTimeInMillis()) * 100L / d);
                    if (num >= 100) {
                        num = 99;
                    }
                    return num;
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class HistoryWidgetImpl
    extends HistoryWidget<SFEEReleaseTask<?>, Record> {
        private HistoryWidgetImpl() {
            super((ModelObject)SFEEReleaseTask.this, Iterators.reverse(SFEEReleaseTask.this.records), ADAPTER);
        }

        public String getDisplayName() {
            return "Deployment History";
        }
    }
}

