/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sfee;

import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.plugins.sfee.CachingUserDetailsService;
import hudson.plugins.sfee.SFEEAuthenticationManager;
import hudson.plugins.sfee.SFEEUserDetailsService;
import hudson.security.SecurityRealm;
import hudson.util.Scrambler;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.providers.AuthenticationProvider;
import org.acegisecurity.providers.ProviderManager;
import org.acegisecurity.providers.rememberme.RememberMeAuthenticationProvider;
import org.acegisecurity.userdetails.UserDetailsService;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SFEESecurityRealm
extends SecurityRealm {
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public SecurityRealm.SecurityComponents createSecurityComponents() {
        ProviderManager manager = new ProviderManager();
        CachingUserDetailsService userDetailsService = new CachingUserDetailsService(new SFEEUserDetailsService());
        RememberMeAuthenticationProvider rememberMeAuthenticationProvider = new RememberMeAuthenticationProvider();
        rememberMeAuthenticationProvider.setKey(Hudson.getInstance().getSecretKey());
        manager.setProviders(Arrays.asList(new AuthenticationProvider[]{rememberMeAuthenticationProvider, new SFEEAuthenticationManager(userDetailsService)}));
        return new SecurityRealm.SecurityComponents((AuthenticationManager)manager, (UserDetailsService)userDetailsService);
    }

    public Descriptor<SecurityRealm> getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends Descriptor<SecurityRealm> {
        private Map<String, String> passwords = new ConcurrentHashMap<String, String>();

        private DescriptorImpl() {
            super(SFEESecurityRealm.class);
            this.load();
        }

        public SFEESecurityRealm newInstance(StaplerRequest req) throws Descriptor.FormException {
            return new SFEESecurityRealm();
        }

        public String getDisplayName() {
            return "SFEE User Database";
        }

        public String getPassword(String user) {
            String result = this.passwords.get(user);
            return result != null ? Scrambler.descramble((String)result) : result;
        }

        public void setPassword(String user, String password) {
            this.passwords.put(user, Scrambler.scramble((String)password));
            this.save();
        }

        public String getHelpFile() {
            return null;
        }
    }
}

