/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sfee;

import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.plugins.sfee.SFEE;
import hudson.plugins.sfee.webservice.ArtifactDetailSoapList;
import hudson.plugins.sfee.webservice.ArtifactDetailSoapRow;
import hudson.plugins.sfee.webservice.FileStorageAppSoap;
import hudson.plugins.sfee.webservice.FrsAppSoap;
import hudson.plugins.sfee.webservice.FrsFileSoapDO;
import hudson.plugins.sfee.webservice.FrsFileSoapList;
import hudson.plugins.sfee.webservice.FrsFileSoapRow;
import hudson.plugins.sfee.webservice.IllegalArgumentFault;
import hudson.plugins.sfee.webservice.InvalidFilterFault;
import hudson.plugins.sfee.webservice.InvalidSessionFault;
import hudson.plugins.sfee.webservice.NoSuchObjectFault;
import hudson.plugins.sfee.webservice.PackageSoapRow;
import hudson.plugins.sfee.webservice.PermissionDeniedFault;
import hudson.plugins.sfee.webservice.ProjectSoapRow;
import hudson.plugins.sfee.webservice.ReleaseSoapDO;
import hudson.plugins.sfee.webservice.ReleaseSoapList;
import hudson.plugins.sfee.webservice.ReleaseSoapRow;
import hudson.plugins.sfee.webservice.SearchQuerySyntaxFault;
import hudson.plugins.sfee.webservice.SourceForgeSoap;
import hudson.plugins.sfee.webservice.SystemFault;
import hudson.plugins.sfee.webservice.TrackerAppSoap;
import hudson.plugins.sfee.webservice.TrackerSoapRow;
import hudson.plugins.sfee.webservice.UserSoapDO;
import hudson.plugins.sfee.webservice.UserSoapRow;
import hudson.plugins.sfee.webservice.VersionMismatchFault;
import java.io.Serializable;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.activation.DataHandler;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceForgeSite
extends JobProperty<AbstractProject<?, ?>>
implements Serializable {
    private transient FrsAppSoap frsApp;
    private transient SourceForgeSoap sfApp;
    private long lastSessionRequest;
    private String site;
    private String userName;
    private String password;
    private transient String sessionId;
    private transient TrackerAppSoap trackerApp;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    private ProjectSoapRow[] projects;
    private long lastProjectsUpdate;

    @DataBoundConstructor
    public SourceForgeSite(String site, String userName, String password) {
        this.site = site;
        this.userName = Util.fixEmpty((String)userName);
        this.password = Util.fixEmpty((String)password);
    }

    public SourceForgeSite() {
    }

    public String getSite() {
        return this.site;
    }

    public synchronized ProjectSoapRow[] getProjects() {
        if (this.sessionId == null || System.currentTimeMillis() - this.lastProjectsUpdate > 15000L) {
            this.projects = SFEE.getProjects(this.getSessionId(), this.site);
            this.lastProjectsUpdate = System.currentTimeMillis();
        }
        return this.projects;
    }

    public synchronized String getSessionId() {
        if (this.sessionId == null || System.currentTimeMillis() - this.lastSessionRequest > 15000L) {
            this.sessionId = SFEE.createSession(this.site, this.userName, this.password);
            this.lastSessionRequest = System.currentTimeMillis();
        }
        return this.sessionId;
    }

    public JobPropertyDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    public FrsAppSoap getFrsApp() {
        if (this.frsApp == null) {
            this.frsApp = SFEE.getSourceForgeApp(this.site, FrsAppSoap.class);
        }
        return this.frsApp;
    }

    public SourceForgeSoap getSfApp() {
        if (this.sfApp == null) {
            this.sfApp = SFEE.getSourceForgeApp(this.site, SourceForgeSoap.class);
        }
        return this.sfApp;
    }

    public TrackerAppSoap getTrackerApp() {
        if (this.trackerApp == null) {
            this.trackerApp = SFEE.getSourceForgeApp(this.site, TrackerAppSoap.class);
        }
        return this.trackerApp;
    }

    public String getURL(String artifactId) {
        return String.format("http://%s/sf/go/%s", this.site, artifactId);
    }

    public FileStorageAppSoap getFileStorageApp() {
        return SFEE.getSourceForgeApp(this.site, FileStorageAppSoap.class);
    }

    public String updateReleaseName(String packageId, String oldName, String newName) throws NoSuchObjectFault, InvalidSessionFault, SystemFault, PermissionDeniedFault, RemoteException {
        FrsAppSoap frsApp = this.getFrsApp();
        String sessionId = this.getSessionId();
        ReleaseSoapList existingReleases = frsApp.getReleaseList(sessionId, packageId);
        for (ReleaseSoapRow row : existingReleases.getDataRows()) {
            if (!oldName.equals(row.getTitle())) continue;
            String releaseId = row.getId();
            ReleaseSoapDO releaseToReplace = frsApp.getReleaseData(sessionId, releaseId);
            releaseToReplace.setTitle(newName);
            frsApp.setReleaseData(sessionId, releaseToReplace);
            return releaseId;
        }
        return null;
    }

    public String getReleaseId(String packageId, String name) throws NoSuchObjectFault, InvalidSessionFault, SystemFault, PermissionDeniedFault, RemoteException {
        String releaseId = null;
        FrsAppSoap frsApp = this.getFrsApp();
        String sessionId = this.getSessionId();
        ReleaseSoapList existingReleases = frsApp.getReleaseList(sessionId, packageId);
        for (ReleaseSoapRow row : existingReleases.getDataRows()) {
            if (!name.equals(row.getTitle())) continue;
            releaseId = row.getId();
            break;
        }
        return releaseId;
    }

    public List<ArtifactDetailSoapRow> findArtifactsResolvedInRelease(String releaseTitle, String projectId) throws InvalidFilterFault, NoSuchObjectFault, InvalidSessionFault, SystemFault, PermissionDeniedFault, RemoteException {
        ArrayList<ArtifactDetailSoapRow> result = new ArrayList<ArtifactDetailSoapRow>();
        String sessionId = this.getSessionId();
        TrackerAppSoap trackerApp = this.getTrackerApp();
        for (TrackerSoapRow trackerRow : this.getTrackers(projectId)) {
            ArtifactDetailSoapList artifactDetailList = trackerApp.getArtifactDetailList(sessionId, trackerRow.getId(), null);
            for (ArtifactDetailSoapRow row : artifactDetailList.getDataRows()) {
                if (!releaseTitle.equals(row.getResolvedInReleaseTitle())) continue;
                result.add(row);
            }
        }
        return result;
    }

    public String createRelease(String packageId, String releaseName, String description, String status, String maturity) throws IllegalArgumentFault, NoSuchObjectFault, InvalidSessionFault, SystemFault, PermissionDeniedFault, RemoteException {
        FrsAppSoap frsApp = this.getFrsApp();
        String sessionId = this.getSessionId();
        ReleaseSoapDO release = frsApp.createRelease(sessionId, packageId, releaseName, description, status, maturity);
        return release.getId();
    }

    public String getFrsId(String releaseId, String fileName) throws InvalidSessionFault, SystemFault, RemoteException {
        String ret = null;
        String sessionId = this.getSessionId();
        FrsAppSoap frsApp = this.getFrsApp();
        FrsFileSoapList fileSoapList = frsApp.getFrsFileList(sessionId, releaseId);
        for (FrsFileSoapRow row : fileSoapList.getDataRows()) {
            if (!fileName.equals(row.getFilename())) continue;
            ret = row.getId();
            break;
        }
        return ret;
    }

    public String uploadFileForRelease(String releaseId, String name, URL sourceURL, boolean forceUpdate) throws InvalidSessionFault, SystemFault, RemoteException {
        return this.uploadFileForRelease(releaseId, name, new DataHandler(sourceURL), forceUpdate);
    }

    public String uploadFileForRelease(String releaseId, String name, DataHandler dataHandler, boolean forceUpdate) throws InvalidSessionFault, SystemFault, RemoteException {
        String frsId;
        String sessionId = this.getSessionId();
        FileStorageAppSoap fileApp = this.getFileStorageApp();
        String fileId = fileApp.uploadFile(sessionId, dataHandler);
        if (forceUpdate && (frsId = this.getFrsId(releaseId, name)) != null) {
            this.getFrsApp().deleteFrsFile(sessionId, frsId);
        }
        FrsFileSoapDO frsFile = this.getFrsApp().createFrsFile(sessionId, releaseId, name, dataHandler.getContentType(), fileId);
        return frsFile.getId();
    }

    public PackageSoapRow[] getReleasePackages(String projectId) throws NoSuchObjectFault, InvalidSessionFault, SystemFault, PermissionDeniedFault, RemoteException {
        return this.getFrsApp().getPackageList(this.getSessionId(), projectId).getDataRows();
    }

    public TrackerSoapRow[] getTrackers(String projectId) throws NoSuchObjectFault, InvalidSessionFault, SystemFault, PermissionDeniedFault, RemoteException {
        return this.getTrackerApp().getTrackerList(this.getSessionId(), projectId).getDataRows();
    }

    public UserSoapRow[] getUsers() throws SearchQuerySyntaxFault, IllegalArgumentFault, InvalidSessionFault, SystemFault, PermissionDeniedFault, RemoteException {
        return this.getSfApp().getUserList(this.getSessionId(), null).getDataRows();
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String createSession(String userName, String password) {
        return SFEE.createSession(this.site, userName, password);
    }

    public UserSoapDO getUserDetails(String username) throws InvalidSessionFault, NoSuchObjectFault, IllegalArgumentFault, RemoteException {
        return this.getSfApp().getUserData(this.getSessionId(), username);
    }

    public ProjectSoapRow[] getProjects(String sessionId) throws InvalidSessionFault, SystemFault, RemoteException {
        return this.getSfApp().getUserProjectList(sessionId).getDataRows();
    }

    public void updateRelease(String releaseId, String maturity, String status) throws NoSuchObjectFault, InvalidSessionFault, SystemFault, PermissionDeniedFault, RemoteException {
        FrsAppSoap frsApp = this.getFrsApp();
        String sessionId = this.getSessionId();
        ReleaseSoapDO releaseData = frsApp.getReleaseData(sessionId, releaseId);
        if (maturity != null) {
            releaseData.setMaturity(maturity);
        }
        if (status != null) {
            releaseData.setStatus(status);
        }
        frsApp.setReleaseData(sessionId, releaseData);
    }

    public void obsoleteRelease(String releaseId) throws VersionMismatchFault, IllegalArgumentFault, NoSuchObjectFault, InvalidSessionFault, SystemFault, PermissionDeniedFault, RemoteException {
        FrsAppSoap frsApp = this.getFrsApp();
        String sessionId = this.getSessionId();
        ReleaseSoapDO releaseData = frsApp.getReleaseData(sessionId, releaseId);
        releaseData.setMaturity("Obsolete");
        releaseData.setTitle("[obsolete] " + releaseData.getTitle());
        frsApp.setReleaseData(sessionId, releaseData);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends JobPropertyDescriptor {
        private SourceForgeSite site;

        protected DescriptorImpl() {
            super(SourceForgeSite.class);
            this.load();
        }

        public String getDisplayName() {
            return "SFEE";
        }

        public boolean isApplicable(Class<? extends Job> klazz) {
            return Hudson.class.isAssignableFrom(klazz);
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.site = (SourceForgeSite)req.bindParameters(SourceForgeSite.class, "sfee.");
            this.save();
            return true;
        }

        public SourceForgeSite getSite() {
            return this.site;
        }
    }
}

