/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.shelveproject;

import hudson.FilePath;
import hudson.model.Hudson;
import hudson.model.Queue;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UnshelveProjectExecutable
implements Queue.Executable {
    private static final Logger LOGGER = Logger.getLogger(UnshelveProjectExecutable.class.getName());
    private final File shelvedProjectDir;
    private final Queue.Task parentTask;

    public UnshelveProjectExecutable(Queue.Task parentTask, File shelvedProjectDir) {
        this.parentTask = parentTask;
        this.shelvedProjectDir = shelvedProjectDir;
    }

    public Queue.Task getParent() {
        return this.parentTask;
    }

    public void run() {
        LOGGER.info("Unshelving project [" + this.shelvedProjectDir + "].");
        try {
            new FilePath(this.shelvedProjectDir).unzip(new FilePath(new File(Hudson.getInstance().getRootDir(), "jobs")));
            this.shelvedProjectDir.delete();
            Hudson.getInstance().restart();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Could not unarchive project archive [" + this.shelvedProjectDir + "].", e);
        }
    }

    public String toString() {
        return "Unshelving Project";
    }
}

