/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.shelveproject;

import hudson.model.Hudson;
import hudson.model.Queue;
import hudson.model.RootAction;
import hudson.security.Permission;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.jvnet.hudson.plugins.shelveproject.ShelvedProject;
import org.jvnet.hudson.plugins.shelveproject.UnshelveProjectTask;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExportedBean(defaultVisibility=999)
public class ShelvedProjectsAction
implements RootAction {
    static final Logger LOGGER = Logger.getLogger(ShelvedProjectsAction.class.getName());

    public String getIconFileName() {
        if (Hudson.getInstance().hasPermission(Permission.CREATE)) {
            return "/plugin/shelve-project-plugin/icons/shelve-project-icon.png";
        }
        return null;
    }

    public String getDisplayName() {
        return "Shelved Projects";
    }

    public String getUrlName() {
        return "/shelvedProjects";
    }

    @Exported
    public List<ShelvedProject> getShelvedProjects() {
        Hudson.getInstance().checkPermission(Permission.CREATE);
        File shelvedProjectsDir = new File(Hudson.getInstance().getRootDir(), "shelvedProjects");
        shelvedProjectsDir.mkdirs();
        Collection shelvedProjectsArchives = FileUtils.listFiles((File)shelvedProjectsDir, (String[])new String[]{"zip"}, (boolean)false);
        LinkedList<ShelvedProject> projects = new LinkedList<ShelvedProject>();
        for (File archive : shelvedProjectsArchives) {
            projects.add(this.getShelvedProjectFromArchive(archive));
        }
        return projects;
    }

    private ShelvedProject getShelvedProjectFromArchive(File archive) {
        ShelvedProject shelvedProject = new ShelvedProject();
        shelvedProject.setProjectName(StringUtils.substringBeforeLast((String)archive.getName(), (String)"-"));
        shelvedProject.setTimestamp(Long.valueOf(StringUtils.substringBefore((String)StringUtils.substringAfterLast((String)archive.getName(), (String)"-"), (String)".")));
        shelvedProject.setArchive(archive);
        shelvedProject.setFormatedDate(this.formatDate(shelvedProject.getTimestamp()));
        return shelvedProject;
    }

    public HttpResponse doUnshelveProject(@QueryParameter(required=true) String project, StaplerRequest request, StaplerResponse response) throws IOException, ServletException {
        Hudson.getInstance().checkPermission(Permission.CREATE);
        LOGGER.info("Unshelving archived project [" + project + "].");
        Hudson.getInstance().getQueue().schedule((Queue.Task)new UnshelveProjectTask(new File(project)), 0);
        return this.createRedirectToMainPage();
    }

    public String formatDate(long timestamp) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z");
        return simpleDateFormat.format(new Date(timestamp));
    }

    private HttpRedirect createRedirectToMainPage() {
        return new HttpRedirect(Hudson.getInstance().getRootUrl());
    }
}

