/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.shelveproject;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.JobProperty;
import hudson.model.listeners.ItemListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hudson.plugins.shelveproject.ShelveProjectProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class ItemListenerImpl
extends ItemListener {
    private static final Logger LOGGER = Logger.getLogger(ItemListenerImpl.class.getName());

    public void onLoaded() {
        for (AbstractProject project : Hudson.getInstance().getAllItems(AbstractProject.class)) {
            this.addShelveProjectProperty(project);
        }
    }

    public void onCreated(Item item) {
        if (item instanceof AbstractProject) {
            AbstractProject project = (AbstractProject)item;
            this.addShelveProjectProperty(project);
        }
    }

    private void addShelveProjectProperty(AbstractProject<?, ?> project) {
        try {
            if (project.getProperty(ShelveProjectProperty.class) == null) {
                project.addProperty((JobProperty)new ShelveProjectProperty());
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Failed to persist " + project, e);
        }
    }
}

