/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.shelveproject;

import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Hudson;
import hudson.model.Queue;
import hudson.security.Permission;
import java.io.IOException;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import org.jvnet.hudson.plugins.shelveproject.ShelveProjectTask;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;

public class ShelveProjectAction
implements Action {
    static final Logger LOGGER = Logger.getLogger(ShelveProjectAction.class.getName());
    private AbstractProject project;
    private boolean isShelvingProject;

    public ShelveProjectAction(AbstractProject project) {
        this.project = project;
        this.isShelvingProject = false;
    }

    public String getIconFileName() {
        if (Hudson.getInstance().hasPermission(Permission.DELETE)) {
            return "/plugin/shelve-project-plugin/icons/shelve-project-icon.png";
        }
        return null;
    }

    public String getDisplayName() {
        return "Shelve Project";
    }

    public String getUrlName() {
        return "shelve";
    }

    public AbstractProject getProject() {
        return this.project;
    }

    public boolean isShelvingProject() {
        return this.isShelvingProject;
    }

    public HttpResponse doShelveProject() throws IOException, ServletException {
        Hudson.getInstance().checkPermission(Permission.DELETE);
        if (!this.isShelvingProject()) {
            LOGGER.info("Shelving project [" + this.getProject().getName() + "].");
            Hudson.getInstance().getQueue().schedule((Queue.Task)new ShelveProjectTask(this.project), 0);
        }
        return this.createRedirectToMainPage();
    }

    private HttpRedirect createRedirectToMainPage() {
        return new HttpRedirect(Hudson.getInstance().getRootUrl());
    }
}

