/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.shelveproject;

import hudson.FilePath;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.model.Queue;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ShelveProjectExecutable
implements Queue.Executable {
    private static final Logger LOGGER = Logger.getLogger(ShelveProjectExecutable.class.getName());
    private final AbstractProject project;
    private final Queue.Task parentTask;

    public ShelveProjectExecutable(Queue.Task parentTask, AbstractProject project) {
        this.parentTask = parentTask;
        this.project = project;
    }

    public Queue.Task getParent() {
        return this.parentTask;
    }

    public void run() {
        if (this.archiveProject()) {
            this.deleteProject();
        }
    }

    public long getEstimatedDuration() {
        return -1L;
    }

    private boolean archiveProject() {
        LOGGER.info("Creating archive for project [" + this.project.getName() + "].");
        try {
            File projectRoot = this.project.getRootDir();
            OutputStream outputStream1 = this.createOutputStream(Hudson.getInstance().getRootDir(), this.project.getName());
            new FilePath(projectRoot).zip(outputStream1, new FileFilter(){

                public boolean accept(File file) {
                    return true;
                }
            });
            outputStream1.close();
            return true;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Could not archive project [" + this.project.getName() + "].", e);
            return false;
        }
    }

    private OutputStream createOutputStream(File rootDir, String projectName) throws FileNotFoundException {
        File baseDir = new File(rootDir, "shelvedProjects");
        baseDir.mkdirs();
        File archive = new File(baseDir, projectName + "-" + System.currentTimeMillis() + ".zip");
        return new FileOutputStream(archive);
    }

    private void deleteProject() {
        LOGGER.info("Deleting project [" + this.project.getName() + "].");
        try {
            this.project.delete();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Could not delete project [" + this.project.getName() + "].", e);
        }
    }

    public String toString() {
        return "Shelving " + this.project.getName();
    }
}

