/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sitemonitor;

import hudson.model.AbstractProject;
import hudson.plugins.sitemonitor.SiteMonitorRecorder;
import hudson.plugins.sitemonitor.SiteMonitorValidator;
import hudson.plugins.sitemonitor.model.Site;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiteMonitorDescriptor
extends BuildStepDescriptor<Publisher> {
    private static final Logger LOGGER = Logger.getLogger(SiteMonitorDescriptor.class.getName());
    private static final Integer DEFAULT_TIMEOUT_IN_SECS = 30;
    private SiteMonitorValidator mValidator;
    private List<Integer> mSuccessResponseCodes;
    private Integer mTimeout;

    public SiteMonitorDescriptor() {
        super(SiteMonitorRecorder.class);
        this.load();
        this.mValidator = new SiteMonitorValidator();
    }

    public final String getDisplayName() {
        return "Monitor Site";
    }

    public final boolean isApplicable(Class<? extends AbstractProject> clazz) {
        return true;
    }

    public final List<Integer> getSuccessResponseCodes() {
        if (this.mSuccessResponseCodes == null) {
            this.mSuccessResponseCodes = new ArrayList();
            this.mSuccessResponseCodes.add(200);
        }
        return this.mSuccessResponseCodes;
    }

    public final String getSuccessResponseCodesCsv() {
        StringBuffer sb = new StringBuffer();
        for (Integer successResponseCode : this.getSuccessResponseCodes()) {
            sb.append(successResponseCode).append(",");
        }
        return sb.toString().replaceFirst(",$", "");
    }

    public final Integer getTimeout() {
        if (this.mTimeout == null) {
            this.mTimeout = DEFAULT_TIMEOUT_IN_SECS;
        }
        return this.mTimeout;
    }

    public final Publisher newInstance(StaplerRequest request, JSONObject json) {
        LOGGER.fine("json: " + json);
        ArrayList<Site> sites = new ArrayList<Site>();
        Object sitesObject = json.get("sites");
        if (sitesObject instanceof JSONObject) {
            for (Object siteObject : json.getJSONObject("sites").values()) {
                String url = String.valueOf(siteObject);
                sites.add(new Site(url));
            }
        } else if (sitesObject instanceof JSONArray) {
            for (Object siteObject : (JSONArray)sitesObject) {
                if (!(siteObject instanceof JSONObject)) continue;
                String url = ((JSONObject)siteObject).getString("url");
                sites.add(new Site(url));
            }
        } else {
            LOGGER.warning("Unable to parse 'sites' object in JSON data. It's neither JSONObject nor JSONArray");
        }
        return new SiteMonitorRecorder(sites);
    }

    public final boolean configure(StaplerRequest request, JSONObject json) {
        LOGGER.fine("json: " + json);
        if (!StringUtils.isBlank((String)json.getString("successResponseCodes"))) {
            this.mSuccessResponseCodes.clear();
            for (String responseCode : json.getString("successResponseCodes").split(",")) {
                this.mSuccessResponseCodes.add(Integer.parseInt(responseCode.trim()));
            }
        }
        this.mTimeout = json.getInt("timeout");
        this.save();
        return true;
    }

    public final FormValidation doCheckUrl(@QueryParameter String value) {
        return this.mValidator.validateUrl(value);
    }

    public final FormValidation doCheckResponseCodes(@QueryParameter String value) {
        return this.mValidator.validateResponseCodes(value);
    }

    public final FormValidation doCheckTimeout(@QueryParameter String value) {
        return this.mValidator.validateTimeout(value);
    }
}

