/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sitemonitor;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.plugins.sitemonitor.SiteMonitorDescriptor;
import hudson.plugins.sitemonitor.SiteMonitorRootAction;
import hudson.plugins.sitemonitor.model.Result;
import hudson.plugins.sitemonitor.model.Site;
import hudson.plugins.sitemonitor.model.Status;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Recorder;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiteMonitorRecorder
extends Recorder {
    private static final int MILLISECS_IN_SECS = 1000;
    private List<Site> mSites;

    public SiteMonitorRecorder(List<Site> sites) {
        this.mSites = sites;
    }

    public final List<Site> getSites() {
        return this.mSites;
    }

    public final boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        ArrayList<Result> results = new ArrayList<Result>();
        SiteMonitorDescriptor descriptor = (SiteMonitorDescriptor)this.getDescriptor();
        boolean hasFailure = false;
        for (Site site : this.mSites) {
            Status status;
            Integer responseCode = null;
            String note = "";
            try {
                HttpURLConnection connection = (HttpURLConnection)new URL(site.getUrl()).openConnection();
                connection.setConnectTimeout(descriptor.getTimeout() * 1000);
                responseCode = connection.getResponseCode();
                List successResponseCodes = descriptor.getSuccessResponseCodes();
                status = successResponseCodes.contains(responseCode) ? Status.UP : Status.ERROR;
            }
            catch (SocketTimeoutException ste) {
                listener.getLogger().println(ste + " - " + ste.getMessage());
                status = Status.DOWN;
            }
            catch (Exception e) {
                note = e + " - " + e.getMessage();
                listener.getLogger().println(note);
                status = Status.EXCEPTION;
            }
            note = "[" + status + "] " + note;
            listener.getLogger().println("URL: " + site.getUrl() + ", response code: " + responseCode + ", status: " + status);
            if (!hasFailure && status != Status.UP) {
                hasFailure = true;
            }
            Result result = new Result(site, responseCode, status, note);
            results.add(result);
        }
        build.addAction((Action)new SiteMonitorRootAction(results));
        hudson.model.Result result = hasFailure ? hudson.model.Result.FAILURE : hudson.model.Result.SUCCESS;
        build.setResult(result);
        return !hasFailure;
    }

    public final BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }
}

