/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.slave_squatter;

import hudson.Util;
import hudson.model.Node;
import hudson.model.Saveable;
import hudson.plugins.slave_squatter.SlaveSquatter;
import hudson.plugins.slave_squatter.SlaveSquatterDescriptor;
import hudson.slaves.NodeProperty;
import hudson.util.DescribableList;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodePropertyImpl
extends NodeProperty<Node> {
    private final DescribableList<SlaveSquatter, SlaveSquatterDescriptor> squatters = new DescribableList(Saveable.NOOP);

    @DataBoundConstructor
    public NodePropertyImpl(List<? extends SlaveSquatter> squatters) throws IOException {
        this.squatters.replaceBy((Collection)Util.fixNull(squatters));
    }

    public DescribableList<SlaveSquatter, SlaveSquatterDescriptor> getSquatters() {
        return this.squatters;
    }

    public int sizeOfReservation(long timestamp) {
        int r = 0;
        for (SlaveSquatter s : this.squatters) {
            r += s.sizeOfReservation(timestamp);
        }
        return r;
    }

    public long timeOfNextChange(long timestamp) {
        long t = Long.MAX_VALUE;
        for (SlaveSquatter s : this.squatters) {
            t = Math.min(t, s.timeOfNextChange(timestamp));
        }
        return t;
    }
}

