/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.slave_squatter.squatters;

import antlr.ANTLRException;
import hudson.Extension;
import hudson.plugins.slave_squatter.SlaveSquatter;
import hudson.plugins.slave_squatter.SlaveSquatterDescriptor;
import hudson.plugins.slave_squatter.squatters.Messages;
import hudson.scheduler.CronTab;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

public class CronSquatter
extends SlaveSquatter {
    public final String format;
    private transient List<Entry> entries;

    @DataBoundConstructor
    public CronSquatter(String format) {
        this.format = format;
        this.readResolve();
    }

    private Object readResolve() {
        this.entries = new ArrayList<Entry>();
        int lineNumber = 0;
        for (String line : this.format.split("\\r?\\n")) {
            ++lineNumber;
            if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
            String[] tokens = line.split(":");
            if (tokens.length != 3) {
                throw new IllegalArgumentException("3 tokens separated by ':' are expected, but found " + tokens.length + " in " + line);
            }
            try {
                this.entries.add(new Entry(Integer.parseInt(tokens[0].trim()), new CronTab(tokens[1].trim(), lineNumber), Long.parseLong(tokens[2].trim()) * 60L * 1000L));
            }
            catch (ANTLRException e) {
                throw new IllegalArgumentException(hudson.scheduler.Messages.CronTabList_InvalidInput((Object)line, (Object)e.toString()), e);
            }
        }
        return this;
    }

    public int sizeOfReservation(long timestamp) {
        int r = 0;
        for (Entry e : this.entries) {
            r += e.sizeOfReservation(timestamp);
        }
        return r;
    }

    public long timeOfNextChange(long timestamp) {
        long l = Long.MAX_VALUE;
        for (Entry e : this.entries) {
            l = Math.min(l, e.timeOfNextChange(timestamp));
        }
        return l;
    }

    @Extension
    public static class DescriptorImpl
    extends SlaveSquatterDescriptor {
        public String getDisplayName() {
            return Messages.CronSquatter_DisplayName();
        }
    }

    public static final class Entry {
        public final CronTab cron;
        public final long duration;
        public final int size;

        public Entry(int size, CronTab cron, long duration) {
            this.cron = cron;
            this.duration = duration;
            this.size = size;
        }

        public int sizeOfReservation(long timestamp) {
            long start = this.cron.floor(timestamp).getTimeInMillis();
            if (start <= timestamp && timestamp < start + this.duration) {
                return this.size;
            }
            return 0;
        }

        public long timeOfNextChange(long timestamp) {
            long end = this.cron.floor(timestamp).getTimeInMillis() + this.duration;
            long start = this.cron.ceil(timestamp).getTimeInMillis();
            if (timestamp < end) {
                return Math.min(end, start);
            }
            return start;
        }
    }
}

