/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.slave_squatter;

import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.queue.FutureLoad;
import hudson.model.queue.LoadPredictor;
import hudson.plugins.slave_squatter.NodePropertyImpl;
import java.util.ArrayList;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class LoadPredictorImpl
extends LoadPredictor {
    public Iterable<FutureLoad> predict(Computer computer, long start, long end) {
        Node n = computer.getNode();
        if (n == null) {
            return Collections.emptyList();
        }
        NodePropertyImpl p = (NodePropertyImpl)n.getNodeProperties().get(NodePropertyImpl.class);
        if (p == null) {
            return Collections.emptyList();
        }
        ArrayList<FutureLoad> r = new ArrayList<FutureLoad>();
        long t = start;
        for (int cnt = 0; t < end && cnt < 256; ++cnt) {
            int sz = p.sizeOfReservation(t);
            long t2 = p.timeOfNextChange(t + 1L);
            if (sz > 0) {
                r.add(new FutureLoad(t, t2 - t, sz));
            }
            t = t2;
        }
        return r;
    }
}

