/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.slave_squatter;

import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.PeriodicWork;
import hudson.model.Queue;
import hudson.plugins.slave_squatter.NodePropertyImpl;
import hudson.plugins.slave_squatter.ReservationExecutable;
import hudson.plugins.slave_squatter.ReservationTask;
import hudson.util.TimeUnit2;

@Extension
public class Maintenance
extends PeriodicWork {
    private boolean inprogress;

    public long getRecurrencePeriod() {
        return TimeUnit2.SECONDS.toMillis(15L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRun() throws Exception {
        Maintenance maintenance = this;
        synchronized (maintenance) {
            if (this.inprogress) {
                return;
            }
            this.inprogress = true;
        }
        try {
            this._run();
        }
        finally {
            maintenance = this;
            synchronized (maintenance) {
                this.inprogress = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _run() {
        Queue q;
        long now = System.currentTimeMillis();
        Hudson h = Hudson.getInstance();
        Queue queue = q = h.getQueue();
        synchronized (queue) {
            for (Queue.Item i : q.getItems()) {
                if (!(i.task instanceof ReservationTask)) continue;
                q.cancel(i.task);
            }
        }
        for (Computer c : h.getComputers()) {
            NodePropertyImpl p;
            Node n = c.getNode();
            if (n == null || (p = (NodePropertyImpl)n.getNodeProperties().get(NodePropertyImpl.class)) == null) continue;
            int r = p.sizeOfReservation(now);
            int current = 0;
            int idle = 0;
            for (Executor e : c.getExecutors()) {
                if (e.getCurrentExecutable() instanceof ReservationExecutable) {
                    if (r >= ++current) continue;
                    e.interrupt();
                    continue;
                }
                if (!e.isIdle()) continue;
                ++idle;
            }
            for (int i = current; i < r && idle > 0; ++i, --idle) {
                q.schedule((Queue.Task)new ReservationTask(n), 0);
            }
        }
    }

    public static Maintenance get() {
        return (Maintenance)((Object)PeriodicWork.all().get(Maintenance.class));
    }
}

