/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sonar;

import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.plugins.sonar.SonarInstallation;
import hudson.plugins.sonar.SonarPublisher;
import hudson.tasks.Publisher;
import hudson.util.ArgumentListBuilder;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SonarPublisher
extends Publisher {
    private final String jobAdditionalProperties;
    private final String installationName;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public SonarPublisher(String installationName, String jobAdditionalProperties) {
        this.jobAdditionalProperties = jobAdditionalProperties;
        this.installationName = installationName;
    }

    public String getJobAdditionalProperties() {
        return StringUtils.defaultString((String)this.jobAdditionalProperties);
    }

    public String getInstallationName() {
        return this.installationName;
    }

    public SonarInstallation getInstallation() {
        if ("".equals(StringUtils.defaultString((String)this.installationName)) && DESCRIPTOR.getInstallations().length > 0) {
            return DESCRIPTOR.getInstallations()[0];
        }
        for (SonarInstallation si : DESCRIPTOR.getInstallations()) {
            if (this.installationName == null || !si.getName().equals(this.installationName)) continue;
            return si;
        }
        return null;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        SonarInstallation sonarInstallation = this.getInstallation();
        if (sonarInstallation == null) {
            listener.getLogger().println("No Sonar installation on this job. " + this.installationName + "," + DESCRIPTOR.getInstallations().length);
            return true;
        }
        if (sonarInstallation.isDisabled()) {
            listener.getLogger().println("Sonar is disabled (version " + sonarInstallation.getName() + "). See Hudson global configuration.");
            return true;
        }
        return this.executeSonar(build, launcher, listener, sonarInstallation);
    }

    private boolean executeSonar(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener, SonarInstallation sonarInstallation) {
        ArgumentListBuilder args = new ArgumentListBuilder();
        String execName = launcher.isUnix() ? "mvn" : "mvn.bat";
        args.add(execName);
        args.addKeyValuePairs("-D", build.getBuildVariables());
        args.addTokenized("org.codehaus.sonar:sonar-maven-plugin:" + sonarInstallation.getVersion() + ":sonar");
        if (!"".equals(StringUtils.defaultString((String)sonarInstallation.getDatabaseDriver()))) {
            args.add("-Dsonar.jdbc.driver=" + sonarInstallation.getDatabaseDriver());
        }
        if (!"".equals(StringUtils.defaultString((String)sonarInstallation.getDatabaseLogin()))) {
            args.add("-Dsonar.jdbc.username=" + sonarInstallation.getDatabaseLogin());
        }
        if (!"".equals(StringUtils.defaultString((String)sonarInstallation.getDatabasePassword()))) {
            args.add("-Dsonar.jdbc.password=" + sonarInstallation.getDatabasePassword());
        }
        if (!"".equals(StringUtils.defaultString((String)sonarInstallation.getDatabaseUrl()))) {
            args.add("-Dsonar.jdbc.url=" + sonarInstallation.getDatabaseUrl());
        }
        if (!"".equals(StringUtils.defaultString((String)sonarInstallation.getServerUrl()))) {
            args.add("-Dsonar.host.url=" + sonarInstallation.getServerUrl());
        }
        args.add("-Dsonar.skipInstall=true");
        String command = args.toStringWithQuote();
        command = command + " " + this.getJobAdditionalProperties();
        command = command + " " + sonarInstallation.getAdditionalProperties();
        try {
            int r = launcher.launch(command, build.getEnvVars(), (OutputStream)listener.getLogger(), build.getProject().getModuleRoot()).join();
            return r == 0;
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError("command execution failed"));
            return false;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return false;
        }
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }
}

