/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sonar;

import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * Exception performing whole class analysis ignored.
 */
public final class SonarInstallation {
    private final String name;
    private final boolean disabled;
    private final String version;
    private final String serverUrl;
    private final String databaseUrl;
    private final String databaseDriver;
    private final String databaseLogin;
    private final String databasePassword;
    private final String additionalProperties;

    @DataBoundConstructor
    public SonarInstallation(String name, boolean disabled, String version, String serverUrl, String databaseUrl, String databaseDriver, String databaseLogin, String databasePassword, String additionalProperties) {
        this.name = name;
        this.disabled = disabled;
        this.version = version;
        this.serverUrl = serverUrl;
        this.databaseUrl = databaseUrl;
        this.databaseDriver = databaseDriver;
        this.databaseLogin = databaseLogin;
        this.databasePassword = databasePassword;
        this.additionalProperties = additionalProperties;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public String getVersion() {
        return this.version;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getDatabaseUrl() {
        return this.databaseUrl;
    }

    public String getDatabaseDriver() {
        return this.databaseDriver;
    }

    public String getDatabaseLogin() {
        return this.databaseLogin;
    }

    public String getDatabasePassword() {
        return this.databasePassword;
    }

    public String getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getPluginCallArgs() {
        StringBuilder builder = new StringBuilder(100);
        builder.append("org.codehaus.sonar:sonar-maven-plugin:");
        builder.append(this.version);
        builder.append(":sonar");
        SonarInstallation.appendUnlessEmpty((StringBuilder)builder, (String)"sonar.jdbc.driver", (String)this.databaseDriver);
        SonarInstallation.appendUnlessEmpty((StringBuilder)builder, (String)"sonar.jdbc.username", (String)this.databaseLogin);
        SonarInstallation.appendUnlessEmpty((StringBuilder)builder, (String)"sonar.jdbc.password", (String)this.databasePassword);
        SonarInstallation.appendUnlessEmpty((StringBuilder)builder, (String)"sonar.jdbc.url", (String)this.databaseUrl);
        SonarInstallation.appendUnlessEmpty((StringBuilder)builder, (String)"sonar.host.url", (String)this.serverUrl);
        SonarInstallation.appendUnlessEmpty((StringBuilder)builder, (String)"sonar.skipInstall", (String)"true");
        if (StringUtils.isNotBlank((String)this.additionalProperties)) {
            builder.append(' ');
            builder.append(this.additionalProperties);
        }
        return builder.toString();
    }

    private static void appendUnlessEmpty(StringBuilder builder, String key, String value) {
        if (!"".equals(StringUtils.defaultString((String)value))) {
            builder.append(" -D");
            builder.append(key);
            builder.append('=');
            builder.append(value);
        }
    }
}

