/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sonar;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.plugins.sonar.SonarInstallation;
import hudson.plugins.sonar.SonarPublisher;
import hudson.plugins.sonar.template.SimpleTemplate;
import hudson.tasks.Maven;
import hudson.tasks.Publisher;
import hudson.util.ArgumentListBuilder;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class SonarPublisher
extends Publisher {
    private final String jobAdditionalProperties;
    private final String installationName;
    private final boolean useSonarLight;
    private final String groupId;
    private final String artifactId;
    private final String projectName;
    private final String projectVersion;
    private final String projectDescription;
    private final String javaVersion;
    private final String projectSrcDir;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public SonarPublisher(String installationName, String jobAdditionalProperties, boolean useSonarLight, String groupId, String artifactId, String projectName, String projectVersion, String projectSrcDir, String javaVersion, String projectDescription) {
        this.jobAdditionalProperties = jobAdditionalProperties;
        this.installationName = installationName;
        this.useSonarLight = useSonarLight;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.projectName = projectName;
        this.projectVersion = projectVersion;
        this.javaVersion = javaVersion;
        this.projectSrcDir = projectSrcDir;
        this.projectDescription = projectDescription;
    }

    public String getJobAdditionalProperties() {
        return StringUtils.defaultString((String)this.jobAdditionalProperties);
    }

    public String getInstallationName() {
        return this.installationName;
    }

    public boolean getUseSonarLight() {
        return this.useSonarLight;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getProjectVersion() {
        return StringUtils.isBlank((String)this.projectVersion) ? "1.0" : this.projectVersion;
    }

    public String getJavaVersion() {
        return StringUtils.isBlank((String)this.javaVersion) ? "1.5" : this.javaVersion;
    }

    public String getProjectSrcDir() {
        return this.projectSrcDir;
    }

    public String getProjectDescription() {
        return StringUtils.isBlank((String)this.projectDescription) ? "" : this.projectDescription;
    }

    public SonarInstallation getInstallation() {
        if ("".equals(StringUtils.defaultString((String)this.installationName)) && DESCRIPTOR.getInstallations().length > 0) {
            return DESCRIPTOR.getInstallations()[0];
        }
        for (SonarInstallation si : DESCRIPTOR.getInstallations()) {
            if (this.installationName == null || !si.getName().equals(this.installationName)) continue;
            return si;
        }
        return null;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        SonarInstallation sonarInstallation = this.getInstallation();
        if (sonarInstallation == null) {
            listener.getLogger().println("No Sonar installation on this job. " + this.installationName + ',' + DESCRIPTOR.getInstallations().length);
            return true;
        }
        if (sonarInstallation.isDisabled()) {
            listener.getLogger().println("Sonar is disabled (version " + sonarInstallation.getName() + "). See Hudson global configuration.");
            return true;
        }
        Maven.MavenInstallation mavenInstallation = SonarPublisher.inferMavenInstallation(build, (PrintStream)listener.getLogger());
        return this.executeSonar(build, launcher, listener, sonarInstallation, mavenInstallation);
    }

    private static Maven.MavenInstallation inferMavenInstallation(AbstractBuild<?, ?> build, PrintStream logger) {
        Maven.MavenInstallation mavenInstallation = null;
        AbstractProject project = build.getProject();
        if (project instanceof Maven.ProjectWithMaven) {
            mavenInstallation = ((Maven.ProjectWithMaven)project).inferMavenInstallation();
        }
        if (mavenInstallation == null && Maven.DESCRIPTOR.getInstallations().length > 0 && (mavenInstallation = Maven.DESCRIPTOR.getInstallations()[0]) != null) {
            logger.println("No Maven installation configured for this job. Using the first one configured in Hudson...");
        }
        if (mavenInstallation == null) {
            logger.println("No Maven installation found. We'll try to call the 'mvn' executable anyway, hoping is in the path...");
        }
        return mavenInstallation;
    }

    private boolean executeSonar(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener, SonarInstallation sonarInstallation, Maven.MavenInstallation mavenInstallation) {
        try {
            Map environmentVars;
            String executable;
            String[] command;
            int r;
            FilePath root = build.getProject().getModuleRoot();
            if (this.useSonarLight) {
                listener.getLogger().println("Generating sonar-pom.xml...");
                this.generatePomForNonMavenProject(root);
            }
            return (r = launcher.launch(command = this.buildCommand(build, sonarInstallation, executable = SonarPublisher.buildExecName((Launcher)launcher, (Maven.MavenInstallation)mavenInstallation)), environmentVars = SonarPublisher.addM2HomeToEnvironmentVars(build, (Maven.MavenInstallation)mavenInstallation), (OutputStream)listener.getLogger(), root).join()) == 0;
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError("command execution failed"));
            return false;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return false;
        }
    }

    private void generatePomForNonMavenProject(FilePath root) throws IOException, InterruptedException {
        SimpleTemplate pomTemplate = new SimpleTemplate("hudson/plugins/sonar/sonar-light-pom.template");
        pomTemplate.setAttribute("groupId", this.getGroupId());
        pomTemplate.setAttribute("artifactId", this.getArtifactId());
        pomTemplate.setAttribute("projectName", this.getProjectName());
        pomTemplate.setAttribute("projectVersion", this.getProjectVersion());
        pomTemplate.setAttribute("projectSrcDir", this.getProjectSrcDir());
        pomTemplate.setAttribute("javaVersion", this.getJavaVersion());
        pomTemplate.setAttribute("projectDescription", this.getProjectDescription());
        pomTemplate.write(root);
    }

    private static Map<String, String> addM2HomeToEnvironmentVars(AbstractBuild<?, ?> build, Maven.MavenInstallation mavenInstallation) {
        Map environmentVars = build.getEnvVars();
        if (mavenInstallation != null) {
            environmentVars.put("M2_HOME", mavenInstallation.getMavenHome());
        }
        return environmentVars;
    }

    private static String buildExecName(Launcher launcher, Maven.MavenInstallation mavenInstallation) {
        String execName;
        String executable = execName = launcher.isUnix() ? "mvn" : "mvn.bat";
        if (mavenInstallation != null) {
            String mavenHome = mavenInstallation.getMavenHome();
            executable = mavenHome + File.separatorChar + "bin" + File.separatorChar + execName;
        }
        return executable;
    }

    private String[] buildCommand(AbstractBuild<?, ?> build, SonarInstallation sonarInstallation, String executable) {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(executable);
        args.addKeyValuePairs("-D", build.getBuildVariables());
        args.addTokenized(sonarInstallation.getPluginCallArgs());
        args.addTokenized(this.getJobAdditionalProperties());
        if (this.useSonarLight) {
            args.addTokenized("--file sonar-pom.xml");
        }
        return args.toCommandArray();
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }
}

