/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sonar;

import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public final class SonarInstallation {
    private final String name;
    private final boolean disabled;
    private final String version;
    private final String serverUrl;
    private final String databaseUrl;
    private final String databaseDriver;
    private final String databaseLogin;
    private final String databasePassword;
    private final String additionalProperties;

    @DataBoundConstructor
    public SonarInstallation(String name, boolean disabled, String version, String serverUrl, String databaseUrl, String databaseDriver, String databaseLogin, String databasePassword, String additionalProperties) {
        this.name = name;
        this.disabled = disabled;
        this.version = version;
        this.serverUrl = serverUrl;
        this.databaseUrl = databaseUrl;
        this.databaseDriver = databaseDriver;
        this.databaseLogin = databaseLogin;
        this.databasePassword = databasePassword;
        this.additionalProperties = additionalProperties;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public String getVersion() {
        return this.version;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getDatabaseUrl() {
        return this.databaseUrl;
    }

    public String getDatabaseDriver() {
        return this.databaseDriver;
    }

    public String getDatabaseLogin() {
        return this.databaseLogin;
    }

    public String getDatabasePassword() {
        return this.databasePassword;
    }

    public String getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getPluginCallArgs() {
        StringBuilder builder = new StringBuilder(100);
        builder.append("org.codehaus.sonar:sonar-maven-plugin:");
        builder.append(this.version);
        builder.append(":sonar");
        SonarInstallation.appendUnlessEmpty(builder, "sonar.jdbc.driver", this.databaseDriver);
        SonarInstallation.appendUnlessEmpty(builder, "sonar.jdbc.username", this.databaseLogin);
        SonarInstallation.appendUnlessEmpty(builder, "sonar.jdbc.password", this.databasePassword);
        SonarInstallation.appendUnlessEmpty(builder, "sonar.jdbc.url", this.databaseUrl);
        SonarInstallation.appendUnlessEmpty(builder, "sonar.host.url", this.serverUrl);
        SonarInstallation.appendUnlessEmpty(builder, "sonar.skipInstall", "true");
        if (StringUtils.isNotBlank((String)this.additionalProperties)) {
            builder.append(' ');
            builder.append(this.additionalProperties);
        }
        return builder.toString();
    }

    private static void appendUnlessEmpty(StringBuilder builder, String key, String value) {
        if (!"".equals(StringUtils.defaultString((String)value))) {
            builder.append(" -D");
            builder.append(key);
            builder.append('=');
            builder.append(value);
        }
    }
}

