/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sonar;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.maven.MavenModuleSet;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.sonar.Messages;
import hudson.plugins.sonar.SonarInstallation;
import hudson.plugins.sonar.template.SimpleTemplate;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Maven;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.triggers.SCMTrigger;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SonarPublisher
extends Notifier {
    private final String jobAdditionalProperties;
    private final String installationName;
    private final String mavenInstallationName;
    private final boolean useSonarLight;
    private final String groupId;
    private final String artifactId;
    private final String projectName;
    private final String projectVersion;
    private final String projectDescription;
    private final String javaVersion;
    private final String projectSrcDir;
    private final String mavenOpts;
    private boolean skipOnScm = true;
    private boolean skipIfBuildFails = true;

    @DataBoundConstructor
    public SonarPublisher(String installationName, String jobAdditionalProperties, boolean useSonarLight, String groupId, String artifactId, String projectName, String projectVersion, String projectSrcDir, String javaVersion, String projectDescription, String mavenOpts, String mavenInstallationName, boolean skipOnScm, boolean skipIfBuildFails) {
        this.jobAdditionalProperties = jobAdditionalProperties;
        this.installationName = installationName;
        this.useSonarLight = useSonarLight;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.projectName = projectName;
        this.projectVersion = projectVersion;
        this.javaVersion = javaVersion;
        this.projectSrcDir = projectSrcDir;
        this.projectDescription = projectDescription;
        this.mavenOpts = mavenOpts;
        this.skipOnScm = skipOnScm;
        this.mavenInstallationName = mavenInstallationName;
        this.skipIfBuildFails = skipIfBuildFails;
    }

    public String getJobAdditionalProperties() {
        return StringUtils.defaultString((String)this.jobAdditionalProperties);
    }

    public String getInstallationName() {
        return this.installationName;
    }

    public boolean isUseSonarLight() {
        return this.useSonarLight;
    }

    public boolean isSkipIfBuildFails() {
        return this.skipIfBuildFails;
    }

    public boolean isSkipOnScm() {
        return this.skipOnScm;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getProjectVersion() {
        return StringUtils.isBlank((String)this.projectVersion) ? "1.0" : this.projectVersion;
    }

    public String getJavaVersion() {
        return StringUtils.isBlank((String)this.javaVersion) ? "1.5" : this.javaVersion;
    }

    public String getProjectSrcDir() {
        return this.projectSrcDir;
    }

    public String getProjectDescription() {
        return StringUtils.isBlank((String)this.projectDescription) ? "" : this.projectDescription;
    }

    public String getMavenOpts() {
        return this.mavenOpts;
    }

    public static boolean isMavenBuilder(AbstractProject currentProject) {
        return currentProject instanceof MavenModuleSet;
    }

    public List<Maven.MavenInstallation> getMavenInstallations() {
        return Arrays.asList(((Maven.DescriptorImpl)Hudson.getInstance().getDescriptorByType(Maven.DescriptorImpl.class)).getInstallations());
    }

    public Maven.MavenInstallation getMavenInstallation() {
        Maven.DescriptorImpl mavenDescriptor = (Maven.DescriptorImpl)Hudson.getInstance().getDescriptorByType(Maven.DescriptorImpl.class);
        if (StringUtils.isEmpty((String)this.mavenInstallationName) && mavenDescriptor.getInstallations().length > 0) {
            return mavenDescriptor.getInstallations()[0];
        }
        for (Maven.MavenInstallation si : this.getMavenInstallations()) {
            if (!StringUtils.equals((String)this.mavenInstallationName, (String)si.getName())) continue;
            return si;
        }
        return null;
    }

    public SonarInstallation getInstallation() {
        DescriptorImpl sonarDescriptor = (DescriptorImpl)Hudson.getInstance().getDescriptorByType(DescriptorImpl.class);
        if (StringUtils.isEmpty((String)this.installationName) && sonarDescriptor.getInstallations().length > 0) {
            return sonarDescriptor.getInstallations()[0];
        }
        for (SonarInstallation si : sonarDescriptor.getInstallations()) {
            if (!StringUtils.equals((String)this.installationName, (String)si.getName())) continue;
            return si;
        }
        return null;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        SonarInstallation sonarInstallation = this.getInstallation();
        String skipLaunchMsg = null;
        if (this.skipIfBuildFails && build.getResult().isWorseThan(Result.SUCCESS)) {
            skipLaunchMsg = Messages.SonarPublisher_BadBuildStatus(build.getResult().toString());
        } else if (sonarInstallation == null) {
            skipLaunchMsg = Messages.SonarPublisher_NoInstallation(this.installationName, ((Maven.DescriptorImpl)Hudson.getInstance().getDescriptorByType(Maven.DescriptorImpl.class)).getInstallations().length);
        } else if (sonarInstallation.isDisabled()) {
            skipLaunchMsg = Messages.SonarPublisher_InstallDisabled(sonarInstallation.getName());
        } else if (this.isSkipOnScm() && this.isSCMTrigger(build)) {
            skipLaunchMsg = Messages.SonarPublisher_SCMBuild();
        }
        if (skipLaunchMsg != null) {
            listener.getLogger().println(skipLaunchMsg);
            return true;
        }
        boolean sonarSuccess = this.executeSonar(build, launcher, listener, sonarInstallation);
        if (!sonarSuccess) {
            build.setResult(Result.FAILURE);
        }
        return sonarSuccess;
    }

    private boolean isSCMTrigger(AbstractBuild<?, ?> build) {
        CauseAction buildCause = (CauseAction)build.getAction(CauseAction.class);
        List buildCauses = buildCause.getCauses();
        for (Cause cause : buildCauses) {
            if (!(cause instanceof SCMTrigger.SCMTriggerCause)) continue;
            return true;
        }
        return false;
    }

    private Maven.MavenInstallation getMavenInstallationForSonar(AbstractBuild<?, ?> build, TaskListener listener) throws IOException, InterruptedException {
        Maven.MavenInstallation mavenInstallation = null;
        if (build.getProject() instanceof Maven.ProjectWithMaven) {
            mavenInstallation = ((Maven.ProjectWithMaven)build.getProject()).inferMavenInstallation();
        }
        if (mavenInstallation == null) {
            mavenInstallation = this.getMavenInstallation();
        }
        return mavenInstallation != null ? mavenInstallation.forNode(build.getBuiltOn(), listener) : mavenInstallation;
    }

    private MavenModuleSet getMavenProject(AbstractBuild build) {
        return build.getProject() instanceof MavenModuleSet ? (MavenModuleSet)build.getProject() : null;
    }

    private boolean executeSonar(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener, SonarInstallation sonarInstallation) {
        try {
            EnvVars environmentVars;
            String executable;
            String[] command;
            int r;
            String pomName;
            Maven.MavenInstallation mavenInstallation = this.getMavenInstallationForSonar(build, (TaskListener)listener);
            FilePath root = build.getProject().getModuleRoot();
            MavenModuleSet mavenModuleProject = this.getMavenProject(build);
            String string = pomName = mavenModuleProject != null ? mavenModuleProject.getRootPOM() : "pom.xml";
            if (this.useSonarLight) {
                this.generatePomForNonMavenProject(root);
                pomName = "sonar-pom.xml";
            }
            return (r = launcher.launch(command = this.buildCommand(build, sonarInstallation, executable = SonarPublisher.buildExecName(launcher, mavenInstallation, listener.getLogger()), pomName), (Map)(environmentVars = this.getMavenEnvironmentVars(build, mavenInstallation, sonarInstallation)), (OutputStream)listener.getLogger(), root).join()) == 0;
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError("command execution failed"));
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    private void generatePomForNonMavenProject(FilePath root) throws IOException, InterruptedException {
        SimpleTemplate pomTemplate = new SimpleTemplate("hudson/plugins/sonar/sonar-light-pom.template");
        pomTemplate.setAttribute("groupId", this.getGroupId());
        pomTemplate.setAttribute("artifactId", this.getArtifactId());
        pomTemplate.setAttribute("projectName", this.getProjectName());
        pomTemplate.setAttribute("projectVersion", this.getProjectVersion());
        pomTemplate.setAttribute("projectSrcDir", this.getProjectSrcDir());
        pomTemplate.setAttribute("javaVersion", this.getJavaVersion());
        pomTemplate.setAttribute("projectDescription", this.getProjectDescription());
        pomTemplate.write(root);
    }

    private EnvVars getMavenEnvironmentVars(AbstractBuild<?, ?> build, Maven.MavenInstallation mavenInstallation, SonarInstallation sonarInstallation) throws IOException, InterruptedException {
        EnvVars environmentVars = build.getEnvironment();
        if (mavenInstallation != null) {
            environmentVars.put((Object)"M2_HOME", (Object)mavenInstallation.getMavenHome());
        }
        String envMavenOpts = this.getMavenOpts();
        MavenModuleSet mavenModuleProject = this.getMavenProject(build);
        if (StringUtils.isEmpty((String)envMavenOpts) && mavenModuleProject != null && StringUtils.isNotEmpty((String)mavenModuleProject.getMavenOpts())) {
            envMavenOpts = mavenModuleProject.getMavenOpts();
        }
        if (StringUtils.isNotEmpty((String)envMavenOpts)) {
            environmentVars.put((Object)"MAVEN_OPTS", (Object)envMavenOpts);
        }
        return environmentVars;
    }

    private static String buildExecName(Launcher launcher, Maven.MavenInstallation mavenInstallation, PrintStream logger) {
        String execName = launcher.isUnix() ? "mvn" : "mvn.bat";
        String separator = launcher.isUnix() ? "/" : "\\";
        String executable = execName;
        if (mavenInstallation != null) {
            String mavenHome = mavenInstallation.getMavenHome();
            executable = mavenHome + separator + "bin" + separator + execName;
        } else {
            logger.println(Messages.SonarPublisher_NoMavenInstallation());
        }
        return executable;
    }

    private String[] buildCommand(AbstractBuild<?, ?> build, SonarInstallation sonarInstallation, String executable, String pomName) {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(executable).add("-e").add("-B").addTokenized("-f " + pomName).addKeyValuePairs("-D", build.getBuildVariables()).addTokenized(sonarInstallation.getPluginCallArgs()).addTokenized(this.getJobAdditionalProperties());
        return args.toCommandArray();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private volatile SonarInstallation[] installations = new SonarInstallation[0];

        public DescriptorImpl() {
            super(SonarPublisher.class);
            this.load();
        }

        public String getDisplayName() {
            return "Sonar";
        }

        public String getHelpFile() {
            return "/plugin/sonar/help.html";
        }

        public SonarInstallation[] getInstallations() {
            return this.installations;
        }

        public boolean configure(StaplerRequest req) {
            this.installations = req.bindParametersToList(SonarInstallation.class, "sonar.").toArray(new SonarInstallation[0]);
            this.save();
            return true;
        }

        public Notifier newInstance(StaplerRequest req) {
            return (Notifier)req.bindParameters(SonarPublisher.class, "sonar.");
        }

        public FormValidation doCheckMandatory(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)Messages.SonarPublisher_MandatoryProperty());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckMandatoryAndNoSpaces(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value) || value.contains(" ")) {
                return FormValidation.error((String)Messages.SonarPublisher_MandatoryPropertySpaces());
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

