/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sonar.template;

import hudson.FilePath;
import hudson.plugins.sonar.template.TemplateException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class SimpleTemplate {
    private String template;

    public SimpleTemplate(String path) {
        InputStream stream = null;
        try {
            stream = this.getClass().getClassLoader().getResourceAsStream(path);
            if (stream == null) {
                throw new TemplateException("Template not found in classloader: " + path);
            }
            this.template = IOUtils.toString((InputStream)stream);
        }
        catch (IOException e) {
            try {
                throw new TemplateException("Could not read template: " + path, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)stream);
    }

    public void setAttribute(String key, String value) {
        this.template = StringUtils.replace((String)this.template, (String)('$' + key + '$'), (String)value);
    }

    public String toString() {
        return this.template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(FilePath path) throws IOException, InterruptedException {
        FilePath pom = path.child("sonar-pom.xml");
        OutputStreamWriter outputStream = new OutputStreamWriter(pom.write());
        try {
            outputStream.write(this.template);
        }
        finally {
            outputStream.close();
        }
    }
}

