/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sonar;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.maven.MavenModuleSet;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.sonar.Messages;
import hudson.plugins.sonar.SonarInstallation;
import hudson.plugins.sonar.template.SimpleTemplate;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Maven;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.triggers.SCMTrigger;
import hudson.triggers.TimerTrigger;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SonarPublisher
extends Notifier {
    private final String jobAdditionalProperties;
    private final String installationName;
    private final String mavenInstallationName;
    private final boolean useSonarLight;
    private final String groupId;
    private final String artifactId;
    private final String projectName;
    private final String projectVersion;
    private final String projectDescription;
    private final String javaVersion;
    private final String projectSrcDir;
    private final String projectSrcEncoding;
    private final String projectBinDir;
    private final String mavenOpts;
    private final boolean reuseReports;
    private final String surefireReportsPath;
    private final String coberturaReportPath;
    private final String cloverReportPath;
    private final boolean scmBuilds;
    private boolean timerBuilds = true;
    private final boolean snapshotDependencyBuilds;
    private final boolean skipIfBuildFails;
    @Deprecated
    private Boolean skipOnScm;

    @DataBoundConstructor
    public SonarPublisher(String installationName, String jobAdditionalProperties, boolean useSonarLight, String groupId, String artifactId, String projectName, String projectVersion, String projectSrcDir, String javaVersion, String projectDescription, String mavenOpts, String mavenInstallationName, boolean snapshotDependencyBuilds, boolean scmBuilds, boolean timerBuilds, boolean skipIfBuildFails, String projectBinDir, boolean reuseReports, String coberturaReportPath, String surefireReportsPath, String cloverReportPath, String projectSrcEncoding) {
        this.jobAdditionalProperties = jobAdditionalProperties;
        this.installationName = installationName;
        this.useSonarLight = useSonarLight;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.projectName = projectName;
        this.projectVersion = projectVersion;
        this.javaVersion = javaVersion;
        this.projectSrcDir = projectSrcDir;
        this.projectDescription = projectDescription;
        this.mavenOpts = mavenOpts;
        this.scmBuilds = scmBuilds;
        this.timerBuilds = timerBuilds;
        this.snapshotDependencyBuilds = snapshotDependencyBuilds;
        this.mavenInstallationName = mavenInstallationName;
        this.skipIfBuildFails = skipIfBuildFails;
        this.projectBinDir = projectBinDir;
        this.reuseReports = reuseReports;
        this.surefireReportsPath = surefireReportsPath;
        this.coberturaReportPath = coberturaReportPath;
        this.cloverReportPath = cloverReportPath;
        this.projectSrcEncoding = projectSrcEncoding;
    }

    @Deprecated
    public Boolean getSkipOnScm() {
        return this.skipOnScm;
    }

    public String getJobAdditionalProperties() {
        return StringUtils.trimToEmpty((String)this.jobAdditionalProperties);
    }

    public String getInstallationName() {
        return this.installationName;
    }

    public boolean isUseSonarLight() {
        return this.useSonarLight;
    }

    public boolean isSkipIfBuildFails() {
        return this.skipIfBuildFails;
    }

    public boolean isTimerBuilds() {
        return this.timerBuilds;
    }

    public boolean isScmBuilds() {
        return this.scmBuilds;
    }

    public boolean isSnapshotDependencyBuilds() {
        return this.snapshotDependencyBuilds;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getProjectVersion() {
        return StringUtils.trimToEmpty((String)this.projectVersion);
    }

    public String getJavaVersion() {
        return StringUtils.trimToEmpty((String)this.javaVersion);
    }

    public String getProjectSrcDir() {
        return StringUtils.trimToEmpty((String)this.projectSrcDir);
    }

    public String getProjectSrcEncoding() {
        return StringUtils.trimToEmpty((String)this.projectSrcEncoding);
    }

    public String getProjectBinDir() {
        return StringUtils.trimToEmpty((String)this.projectBinDir);
    }

    public String getProjectDescription() {
        return StringUtils.trimToEmpty((String)this.projectDescription);
    }

    public String getMavenOpts() {
        return this.mavenOpts;
    }

    public boolean isReuseReports() {
        return this.reuseReports;
    }

    public String getSurefireReportsPath() {
        return StringUtils.trimToEmpty((String)this.surefireReportsPath);
    }

    public String getCoberturaReportPath() {
        return StringUtils.trimToEmpty((String)this.coberturaReportPath);
    }

    public String getCloverReportPath() {
        return StringUtils.trimToEmpty((String)this.cloverReportPath);
    }

    public static boolean isMavenBuilder(AbstractProject currentProject) {
        return currentProject instanceof MavenModuleSet;
    }

    public List<Maven.MavenInstallation> getMavenInstallations() {
        return Arrays.asList(((Maven.DescriptorImpl)Hudson.getInstance().getDescriptorByType(Maven.DescriptorImpl.class)).getInstallations());
    }

    public Maven.MavenInstallation getMavenInstallation() {
        List<Maven.MavenInstallation> installations = this.getMavenInstallations();
        if (StringUtils.isEmpty((String)this.mavenInstallationName) && !installations.isEmpty()) {
            return installations.get(0);
        }
        for (Maven.MavenInstallation install : installations) {
            if (!StringUtils.equals((String)this.mavenInstallationName, (String)install.getName())) continue;
            return install;
        }
        return null;
    }

    public SonarInstallation getInstallation() {
        DescriptorImpl sonarDescriptor = (DescriptorImpl)Hudson.getInstance().getDescriptorByType(DescriptorImpl.class);
        if (StringUtils.isEmpty((String)this.installationName) && sonarDescriptor.getInstallations().length > 0) {
            return sonarDescriptor.getInstallations()[0];
        }
        for (SonarInstallation si : sonarDescriptor.getInstallations()) {
            if (!StringUtils.equals((String)this.installationName, (String)si.getName())) continue;
            return si;
        }
        return null;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        SonarInstallation sonarInstallation = this.getInstallation();
        String skipLaunchMsg = null;
        if (this.skipIfBuildFails && build.getResult().isWorseThan(Result.SUCCESS)) {
            skipLaunchMsg = Messages.SonarPublisher_BadBuildStatus(build.getResult().toString());
        } else if (sonarInstallation == null) {
            skipLaunchMsg = Messages.SonarPublisher_NoInstallation(this.installationName, ((Maven.DescriptorImpl)Hudson.getInstance().getDescriptorByType(Maven.DescriptorImpl.class)).getInstallations().length);
        } else if (sonarInstallation.isDisabled()) {
            skipLaunchMsg = Messages.SonarPublisher_InstallDisabled(sonarInstallation.getName());
        } else if (!this.isScmBuilds() && this.isTrigger(build, SCMTrigger.SCMTriggerCause.class)) {
            skipLaunchMsg = Messages.SonarPublisher_SCMBuild();
        } else if (!this.isTimerBuilds() && this.isTrigger(build, TimerTrigger.TimerTriggerCause.class)) {
            skipLaunchMsg = Messages.SonarPublisher_TimerBuild();
        } else if (!this.isSnapshotDependencyBuilds() && this.isTrigger(build, Cause.UpstreamCause.class)) {
            skipLaunchMsg = Messages.SonarPublisher_SnapshotDepBuild();
        }
        if (skipLaunchMsg != null) {
            listener.getLogger().println(skipLaunchMsg);
            return true;
        }
        boolean sonarSuccess = this.executeSonar(build, launcher, listener, sonarInstallation);
        if (!sonarSuccess) {
            build.setResult(Result.FAILURE);
        }
        return sonarSuccess;
    }

    private boolean isTrigger(AbstractBuild<?, ?> build, Class<? extends Cause> trigger) {
        CauseAction buildCause = (CauseAction)build.getAction(CauseAction.class);
        List buildCauses = buildCause.getCauses();
        for (Cause cause : buildCauses) {
            if (!cause.getClass().equals(trigger)) continue;
            return true;
        }
        return false;
    }

    private Maven.MavenInstallation getMavenInstallationForSonar(AbstractBuild<?, ?> build, TaskListener listener) throws IOException, InterruptedException {
        Maven.MavenInstallation mavenInstallation = null;
        if (build.getProject() instanceof Maven.ProjectWithMaven) {
            mavenInstallation = ((Maven.ProjectWithMaven)build.getProject()).inferMavenInstallation();
        }
        if (mavenInstallation == null) {
            mavenInstallation = this.getMavenInstallation();
        }
        return mavenInstallation != null ? mavenInstallation.forNode(build.getBuiltOn(), listener) : mavenInstallation;
    }

    private MavenModuleSet getMavenProject(AbstractBuild build) {
        return build.getProject() instanceof MavenModuleSet ? (MavenModuleSet)build.getProject() : null;
    }

    private boolean executeSonar(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener, SonarInstallation sonarInstallation) {
        try {
            String pomName;
            Maven.MavenInstallation mavenInstallation = this.getMavenInstallationForSonar(build, (TaskListener)listener);
            FilePath root = build.getProject().getModuleRoot();
            MavenModuleSet mavenModuleProject = this.getMavenProject(build);
            String string = pomName = mavenModuleProject != null ? mavenModuleProject.getRootPOM() : "pom.xml";
            if (this.useSonarLight) {
                this.generatePomForNonMavenProject(root);
                pomName = "sonar-pom.xml";
            }
            String executable = this.buildExecName(launcher, mavenInstallation, listener.getLogger());
            Launcher.ProcStarter starter = launcher.launch();
            starter.cmds(this.buildCommand(launcher, listener, build, sonarInstallation, executable, pomName, mavenModuleProject));
            starter.envs((Map)this.getMavenEnvironmentVars(listener, build, mavenInstallation, sonarInstallation));
            starter.pwd(root);
            starter.stderr((OutputStream)listener.getLogger());
            starter.stdout((OutputStream)listener.getLogger());
            return starter.join() == 0;
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError("command execution failed"));
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    private void generatePomForNonMavenProject(FilePath root) throws IOException, InterruptedException {
        SimpleTemplate pomTemplate = new SimpleTemplate("hudson/plugins/sonar/sonar-light-pom.template");
        pomTemplate.setAttribute("groupId", this.getGroupId());
        pomTemplate.setAttribute("artifactId", this.getArtifactId());
        pomTemplate.setAttribute("projectName", this.getProjectName());
        pomTemplate.setAttribute("projectVersion", StringUtils.isEmpty((String)this.getProjectVersion()) ? "1.0" : this.getProjectVersion());
        pomTemplate.setAttribute("javaVersion", StringUtils.isEmpty((String)this.getJavaVersion()) ? "1.5" : this.getJavaVersion());
        List<String> srcDirs = this.getProjectSrcDirsList();
        boolean multiSources = srcDirs.size() > 1;
        this.setPomElement("sourceDirectory", srcDirs.get(0), true, pomTemplate);
        pomTemplate.setAttribute("srcDirsPlugin", multiSources ? this.generateSrcDirsPluginTemplate(srcDirs).toString() : "");
        this.setPomElement("project.build.sourceEncoding", this.getProjectSrcEncoding(), true, pomTemplate);
        this.setPomElement("encoding", this.getProjectSrcEncoding(), true, pomTemplate);
        this.setPomElement("description", this.getProjectDescription(), true, pomTemplate);
        this.setPomElement("sonar.phase", multiSources ? "generate-sources" : "", true, pomTemplate);
        this.setPomElement("outputDirectory", this.getProjectBinDir(), StringUtils.isNotBlank((String)this.getProjectBinDir()), pomTemplate);
        this.setPomElement("sonar.dynamicAnalysis", this.isReuseReports() ? "reuseReports" : "false", true, pomTemplate);
        this.setPomElement("sonar.surefire.reportsPath", this.getSurefireReportsPath(), this.isReuseReports(), pomTemplate);
        this.setPomElement("sonar.cobertura.reportPath", this.getCoberturaReportPath(), this.isReuseReports(), pomTemplate);
        this.setPomElement("sonar.clover.reportPath", this.getCloverReportPath(), this.isReuseReports(), pomTemplate);
        pomTemplate.write(root);
    }

    private SimpleTemplate generateSrcDirsPluginTemplate(List<String> srcDirs) throws IOException, InterruptedException {
        SimpleTemplate srcTemplate = new SimpleTemplate("hudson/plugins/sonar/sonar-multi-sources.template");
        StringBuffer sourcesXml = new StringBuffer();
        for (int i = 1; i < srcDirs.size(); ++i) {
            sourcesXml.append("<source><![CDATA[").append(StringUtils.trim((String)srcDirs.get(i))).append("]]></source>\n");
        }
        srcTemplate.setAttribute("sources", sourcesXml.toString());
        return srcTemplate;
    }

    private List<String> getProjectSrcDirsList() {
        String[] dirs = StringUtils.split((String)this.getProjectSrcDir(), (char)',');
        return Arrays.asList(dirs);
    }

    private void setPomElement(String tagName, String tagValue, boolean enabled, SimpleTemplate template) {
        String tagContent = enabled && StringUtils.isNotBlank((String)tagValue) ? "<" + tagName + "><![CDATA[" + tagValue + "]]></" + tagName + ">" : "";
        template.setAttribute(tagName, tagContent);
    }

    private EnvVars getMavenEnvironmentVars(BuildListener listener, AbstractBuild<?, ?> build, Maven.MavenInstallation mavenInstallation, SonarInstallation sonarInstallation) throws IOException, InterruptedException {
        EnvVars environmentVars = build.getEnvironment((TaskListener)listener);
        if (mavenInstallation != null) {
            environmentVars.put((Object)"M2_HOME", (Object)mavenInstallation.getHome());
        }
        String envMavenOpts = this.getMavenOpts();
        MavenModuleSet mavenModuleProject = this.getMavenProject(build);
        if (StringUtils.isEmpty((String)envMavenOpts) && mavenModuleProject != null && StringUtils.isNotEmpty((String)mavenModuleProject.getMavenOpts())) {
            envMavenOpts = mavenModuleProject.getMavenOpts();
        }
        if (StringUtils.isNotEmpty((String)envMavenOpts)) {
            environmentVars.put((Object)"MAVEN_OPTS", (Object)envMavenOpts);
        }
        return environmentVars;
    }

    private String buildExecName(Launcher launcher, Maven.MavenInstallation mavenInstallation, PrintStream logger) {
        String execName = launcher.isUnix() ? "mvn" : "mvn.bat";
        String separator = launcher.isUnix() ? "/" : "\\";
        String executable = execName;
        if (mavenInstallation != null) {
            String mavenHome = mavenInstallation.getHome();
            executable = mavenHome + separator + "bin" + separator + execName;
        } else {
            logger.println(Messages.SonarPublisher_NoMavenInstallation());
        }
        return executable;
    }

    private ArgumentListBuilder buildCommand(Launcher launcher, BuildListener listener, AbstractBuild<?, ?> build, SonarInstallation sonarInstallation, String executable, String pomName, MavenModuleSet mms) throws IOException, InterruptedException {
        EnvVars envVars = build.getEnvironment((TaskListener)listener);
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(executable).add("-e").add("-B");
        args.addTokenized("-f " + pomName);
        args.addKeyValuePairs("-D", build.getBuildVariables());
        this.addTokenizedAndQuoted(launcher.isUnix(), args, sonarInstallation.getPluginCallArgs(envVars));
        this.addTokenizedAndQuoted(launcher.isUnix(), args, envVars.expand(sonarInstallation.getAdditionalProperties()));
        this.addTokenizedAndQuoted(launcher.isUnix(), args, envVars.expand(this.getJobAdditionalProperties()));
        if (mms != null && mms.usesPrivateRepository()) {
            args.add("-Dmaven.repo.local=" + mms.getWorkspace().child(".repository").getRemote());
        }
        args.add("sonar:sonar");
        return args;
    }

    private void addTokenizedAndQuoted(boolean isUnix, ArgumentListBuilder args, String argsString) {
        if (StringUtils.isNotBlank((String)argsString)) {
            for (String argToken : Util.tokenize((String)argsString)) {
                if (!isUnix && argToken.contains("&")) {
                    args.addQuoted(argToken);
                    continue;
                }
                args.add(argToken);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private volatile SonarInstallation[] installations = new SonarInstallation[0];

        public DescriptorImpl() {
            super(SonarPublisher.class);
            this.load();
        }

        public String getDisplayName() {
            return "Sonar";
        }

        public String getHelpFile() {
            return "/plugin/sonar/help.html";
        }

        public SonarInstallation[] getInstallations() {
            return this.installations;
        }

        public boolean configure(StaplerRequest req, JSONObject json) {
            this.installations = req.bindParametersToList(SonarInstallation.class, "sonar.").toArray(new SonarInstallation[0]);
            this.save();
            return true;
        }

        public Notifier newInstance(StaplerRequest req, JSONObject json) {
            return (Notifier)req.bindParameters(SonarPublisher.class, "sonar.");
        }

        public FormValidation doCheckMandatory(@QueryParameter String value) {
            return StringUtils.isBlank((String)value) ? FormValidation.error((String)Messages.SonarPublisher_MandatoryProperty()) : FormValidation.ok();
        }

        public FormValidation doCheckMandatoryAndNoSpaces(@QueryParameter String value) {
            return StringUtils.isBlank((String)value) || value.contains(" ") ? FormValidation.error((String)Messages.SonarPublisher_MandatoryPropertySpaces()) : FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

