/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sonar;

import hudson.plugins.sonar.model.TriggersConfig;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class SonarInstallation {
    private final String name;
    private final boolean disabled;
    private final String serverUrl;
    private final String databaseUrl;
    private final String databaseDriver;
    private final String databaseLogin;
    private final String databasePassword;
    private final String additionalProperties;
    private TriggersConfig triggers;
    @Deprecated
    private transient String version;

    public SonarInstallation(String name) {
        this(name, false, null, null, null, null, null, null, null);
    }

    @DataBoundConstructor
    public SonarInstallation(String name, boolean disabled, String serverUrl, String databaseUrl, String databaseDriver, String databaseLogin, String databasePassword, String additionalProperties, TriggersConfig triggers) {
        this.name = name;
        this.disabled = disabled;
        this.serverUrl = serverUrl;
        this.databaseUrl = databaseUrl;
        this.databaseDriver = databaseDriver;
        this.databaseLogin = databaseLogin;
        this.databasePassword = databasePassword;
        this.additionalProperties = additionalProperties;
        this.triggers = triggers;
        this.version = "";
    }

    public String getName() {
        return this.name;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getDatabaseUrl() {
        return this.databaseUrl;
    }

    public String getDatabaseDriver() {
        return this.databaseDriver;
    }

    public String getDatabaseLogin() {
        return this.databaseLogin;
    }

    public String getDatabasePassword() {
        return this.databasePassword;
    }

    public String getAdditionalProperties() {
        return this.additionalProperties;
    }

    public TriggersConfig getTriggers() {
        if (this.triggers == null) {
            this.triggers = new TriggersConfig();
        }
        return this.triggers;
    }

    public String getPluginCallArgs() {
        StringBuilder sb = new StringBuilder(100);
        this.appendUnlessEmpty(sb, "sonar.jdbc.driver", this.getDatabaseDriver());
        this.appendUnlessEmpty(sb, "sonar.jdbc.username", this.getDatabaseLogin());
        this.appendUnlessEmpty(sb, "sonar.jdbc.password", this.getDatabasePassword());
        this.appendUnlessEmpty(sb, "sonar.jdbc.url", this.getDatabaseUrl());
        this.appendUnlessEmpty(sb, "sonar.host.url", this.getServerUrl());
        return sb.toString();
    }

    void appendUnlessEmpty(StringBuilder sb, String key, String value) {
        if (StringUtils.isNotEmpty((String)StringUtils.defaultString((String)value))) {
            sb.append(key);
            sb.append('=');
            sb.append(value);
            sb.append('\n');
        }
    }

    public String getServerLink() {
        return StringUtils.isEmpty((String)this.getServerUrl()) ? "http://localhost:9000" : this.getServerUrl();
    }

    private String getServerLink(String prefix, String groupId, String artifactId) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getServerLink()).append(prefix).append(groupId).append(':').append(artifactId);
        return builder.toString();
    }

    public String getProjectLink(String groupId, String artifactId) {
        return this.getServerLink("/project/index/", groupId, artifactId);
    }

    public String getComponentLink(String groupId, String artifactId) {
        return this.getServerLink("/components/index/", groupId, artifactId);
    }
}

