/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sonar.model;

import hudson.plugins.sonar.model.ReportsConfig;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class LightProjectConfig {
    private final String groupId;
    private final String artifactId;
    private final String projectName;
    private final String projectVersion;
    private final String projectDescription;
    private final String javaVersion;
    private final String projectSrcDir;
    private final String projectSrcEncoding;
    private final String projectBinDir;
    private final ReportsConfig reports;

    public LightProjectConfig(String groupId, String artifactId, String projectName) {
        this(groupId, artifactId, projectName, null, null, null, null, null, null, null);
    }

    @DataBoundConstructor
    public LightProjectConfig(String groupId, String artifactId, String projectName, String projectVersion, String projectDescription, String javaVersion, String projectSrcDir, String projectSrcEncoding, String projectBinDir, ReportsConfig reports) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.projectName = projectName;
        this.projectVersion = projectVersion;
        this.projectDescription = projectDescription;
        this.javaVersion = javaVersion;
        this.projectSrcDir = projectSrcDir;
        this.projectSrcEncoding = projectSrcEncoding;
        this.projectBinDir = projectBinDir;
        this.reports = reports;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getProjectVersion() {
        return StringUtils.trimToEmpty((String)this.projectVersion);
    }

    public String getProjectDescription() {
        return StringUtils.trimToEmpty((String)this.projectDescription);
    }

    public String getJavaVersion() {
        return StringUtils.trimToEmpty((String)this.javaVersion);
    }

    public String getProjectSrcDir() {
        return StringUtils.trimToEmpty((String)this.projectSrcDir);
    }

    public String getProjectSrcEncoding() {
        return StringUtils.trimToEmpty((String)this.projectSrcEncoding);
    }

    public String getProjectBinDir() {
        return StringUtils.trimToEmpty((String)this.projectBinDir);
    }

    public ReportsConfig getReports() {
        return this.reports;
    }

    public boolean isReuseReports() {
        return this.reports != null;
    }
}

