// CHECKSTYLE:OFF

package hudson.plugins.sonar;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;

@SuppressWarnings({
    "",
    "PMD"
})
public class Messages {

    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Analyzed by Sonar
     * 
     */
    public static String BuildSonarAction_Tooltip() {
        return holder.format("BuildSonarAction.Tooltip");
    }

    /**
     * Analyzed by Sonar
     * 
     */
    public static Localizable _BuildSonarAction_Tooltip() {
        return new Localizable(holder, "BuildSonarAction.Tooltip");
    }

    /**
     * Sonar is disabled ({0}). See Hudson global configuration.
     * 
     */
    public static String SonarPublisher_InstallDisabled(Object arg1) {
        return holder.format("SonarPublisher.InstallDisabled", arg1);
    }

    /**
     * Sonar is disabled ({0}). See Hudson global configuration.
     * 
     */
    public static Localizable _SonarPublisher_InstallDisabled(Object arg1) {
        return new Localizable(holder, "SonarPublisher.InstallDisabled", arg1);
    }

    /**
     * No Maven installation found. Call the 'mvn' executable from path
     * 
     */
    public static String SonarPublisher_NoMavenInstallation() {
        return holder.format("SonarPublisher.NoMavenInstallation");
    }

    /**
     * No Maven installation found. Call the 'mvn' executable from path
     * 
     */
    public static Localizable _SonarPublisher_NoMavenInstallation() {
        return new Localizable(holder, "SonarPublisher.NoMavenInstallation");
    }

    /**
     * Skipping sonar analysis due to timer build trigger
     * 
     */
    public static String SonarPublisher_TimerBuild() {
        return holder.format("SonarPublisher.TimerBuild");
    }

    /**
     * Skipping sonar analysis due to timer build trigger
     * 
     */
    public static Localizable _SonarPublisher_TimerBuild() {
        return new Localizable(holder, "SonarPublisher.TimerBuild");
    }

    /**
     * Skipping sonar analysis due to SCM build trigger
     * 
     */
    public static String SonarPublisher_SCMBuild() {
        return holder.format("SonarPublisher.SCMBuild");
    }

    /**
     * Skipping sonar analysis due to SCM build trigger
     * 
     */
    public static Localizable _SonarPublisher_SCMBuild() {
        return new Localizable(holder, "SonarPublisher.SCMBuild");
    }

    /**
     * Skipping sonar analysis due to user build trigger
     * 
     */
    public static String SonarPublisher_UserBuild() {
        return holder.format("SonarPublisher.UserBuild");
    }

    /**
     * Skipping sonar analysis due to user build trigger
     * 
     */
    public static Localizable _SonarPublisher_UserBuild() {
        return new Localizable(holder, "SonarPublisher.UserBuild");
    }

    /**
     * Sonar
     * 
     */
    public static String SonarAction_Sonar() {
        return holder.format("SonarAction.Sonar");
    }

    /**
     * Sonar
     * 
     */
    public static Localizable _SonarAction_Sonar() {
        return new Localizable(holder, "SonarAction.Sonar");
    }

    /**
     * No Sonar installation on this job. {0}, available installations count : {1}
     * 
     */
    public static String SonarPublisher_NoInstallation(Object arg1, Object arg2) {
        return holder.format("SonarPublisher.NoInstallation", arg1, arg2);
    }

    /**
     * No Sonar installation on this job. {0}, available installations count : {1}
     * 
     */
    public static Localizable _SonarPublisher_NoInstallation(Object arg1, Object arg2) {
        return new Localizable(holder, "SonarPublisher.NoInstallation", arg1, arg2);
    }

    /**
     * This property is mandatory.
     * 
     */
    public static String SonarPublisher_MandatoryProperty() {
        return holder.format("SonarPublisher.MandatoryProperty");
    }

    /**
     * This property is mandatory.
     * 
     */
    public static Localizable _SonarPublisher_MandatoryProperty() {
        return new Localizable(holder, "SonarPublisher.MandatoryProperty");
    }

    /**
     * Skipping sonar analysis due to bad build status {0}
     * 
     */
    public static String SonarPublisher_BadBuildStatus(Object arg1) {
        return holder.format("SonarPublisher.BadBuildStatus", arg1);
    }

    /**
     * Skipping sonar analysis due to bad build status {0}
     * 
     */
    public static Localizable _SonarPublisher_BadBuildStatus(Object arg1) {
        return new Localizable(holder, "SonarPublisher.BadBuildStatus", arg1);
    }

    /**
     * This property is mandatory and cannot contain spaces.
     * 
     */
    public static String SonarPublisher_MandatoryPropertySpaces() {
        return holder.format("SonarPublisher.MandatoryPropertySpaces");
    }

    /**
     * This property is mandatory and cannot contain spaces.
     * 
     */
    public static Localizable _SonarPublisher_MandatoryPropertySpaces() {
        return new Localizable(holder, "SonarPublisher.MandatoryPropertySpaces");
    }

    /**
     * Skipping sonar analysis due to snapshot dependency build trigger
     * 
     */
    public static String SonarPublisher_SnapshotDepBuild() {
        return holder.format("SonarPublisher.SnapshotDepBuild");
    }

    /**
     * Skipping sonar analysis due to snapshot dependency build trigger
     * 
     */
    public static Localizable _SonarPublisher_SnapshotDepBuild() {
        return new Localizable(holder, "SonarPublisher.SnapshotDepBuild");
    }

}
