/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sonar.model;

import hudson.model.AbstractBuild;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Result;
import hudson.plugins.sonar.Messages;
import hudson.triggers.SCMTrigger;
import hudson.triggers.TimerTrigger;
import java.io.Serializable;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class TriggersConfig
implements Serializable {
    private boolean scmBuilds;
    private boolean timerBuilds;
    private boolean userBuilds;
    private boolean snapshotDependencyBuilds;
    private boolean skipIfBuildFails;

    public TriggersConfig() {
    }

    @DataBoundConstructor
    public TriggersConfig(boolean scmBuilds, boolean timerBuilds, boolean userBuilds, boolean snapshotDependencyBuilds, boolean skipIfBuildFails) {
        this.scmBuilds = scmBuilds;
        this.timerBuilds = timerBuilds;
        this.userBuilds = userBuilds;
        this.snapshotDependencyBuilds = snapshotDependencyBuilds;
        this.skipIfBuildFails = skipIfBuildFails;
    }

    public boolean isScmBuilds() {
        return this.scmBuilds;
    }

    public void setScmBuilds(boolean scmBuilds) {
        this.scmBuilds = scmBuilds;
    }

    public boolean isTimerBuilds() {
        return this.timerBuilds;
    }

    public void setTimerBuilds(boolean timerBuilds) {
        this.timerBuilds = timerBuilds;
    }

    public boolean isUserBuilds() {
        return this.userBuilds;
    }

    public void setUserBuilds(boolean userBuilds) {
        this.userBuilds = userBuilds;
    }

    public boolean isSnapshotDependencyBuilds() {
        return this.snapshotDependencyBuilds;
    }

    public void setSnapshotDependencyBuilds(boolean snapshotDependencyBuilds) {
        this.snapshotDependencyBuilds = snapshotDependencyBuilds;
    }

    public boolean isSkipIfBuildFails() {
        return this.skipIfBuildFails;
    }

    public void setSkipIfBuildFails(boolean skipIfBuildFails) {
        this.skipIfBuildFails = skipIfBuildFails;
    }

    public String isSkipSonar(AbstractBuild<?, ?> build) {
        if (this.isSkipIfBuildFails() && build.getResult().isWorseThan(Result.SUCCESS)) {
            return Messages.SonarPublisher_BadBuildStatus((Object)build.getResult().toString());
        }
        if (!this.isScmBuilds() && TriggersConfig.isTrigger(build, SCMTrigger.SCMTriggerCause.class)) {
            return Messages.SonarPublisher_SCMBuild();
        }
        if (!this.isTimerBuilds() && TriggersConfig.isTrigger(build, TimerTrigger.TimerTriggerCause.class)) {
            return Messages.SonarPublisher_TimerBuild();
        }
        if (!this.isUserBuilds() && TriggersConfig.isTrigger(build, Cause.UserCause.class)) {
            return Messages.SonarPublisher_UserBuild();
        }
        if (!this.isSnapshotDependencyBuilds() && TriggersConfig.isTrigger(build, Cause.UpstreamCause.class)) {
            return Messages.SonarPublisher_SnapshotDepBuild();
        }
        return null;
    }

    private static boolean isTrigger(AbstractBuild<?, ?> build, Class<? extends Cause> trigger) {
        CauseAction buildCause = (CauseAction)build.getAction(CauseAction.class);
        List buildCauses = buildCause.getCauses();
        for (Cause cause : buildCauses) {
            if (!cause.getClass().equals(trigger)) continue;
            return true;
        }
        return false;
    }
}

