/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sonar.utils;

import hudson.Launcher;
import hudson.Util;
import hudson.maven.MavenModuleSet;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.plugins.sonar.SonarInstallation;
import hudson.plugins.sonar.SonarPublisher;
import hudson.tasks.Maven;
import hudson.util.ArgumentListBuilder;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public final class SonarHelper {
    public static final String MAVEN_PROPERTIES = "-e -B";

    private SonarHelper() {
    }

    public static void appendUnlessEmpty(StringBuilder builder, String key, String value) {
        if (StringUtils.isNotEmpty((String)StringUtils.defaultString((String)value))) {
            builder.append(" -D");
            builder.append(key);
            builder.append('=');
            builder.append(value.contains(" ") ? "'" + value + "'" : value);
        }
    }

    public static void addTokenizedAndQuoted(boolean isUnix, ArgumentListBuilder args, String argsString) {
        if (StringUtils.isNotBlank((String)argsString)) {
            for (String argToken : Util.tokenize((String)argsString)) {
                if (!isUnix && argToken.contains("&")) {
                    args.addQuoted(argToken);
                    continue;
                }
                args.add(argToken);
            }
        }
    }

    public static boolean executeMaven(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener, String targets, String mavenName, String pom, String properties, String jvmOptions, boolean usePrivateRepository) throws IOException, InterruptedException {
        return new Maven(targets, mavenName, pom, properties, jvmOptions, usePrivateRepository).perform(build, launcher, listener);
    }

    public static boolean executeMaven(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener, String mavenName, String pom, SonarInstallation sonarInstallation, SonarPublisher sonarPublisher) throws IOException, InterruptedException {
        MavenModuleSet mavenModuleProject = sonarPublisher.getMavenProject(build);
        String jvmOptions = sonarPublisher.getMavenOpts();
        if (StringUtils.isEmpty((String)jvmOptions) && mavenModuleProject != null && StringUtils.isNotEmpty((String)mavenModuleProject.getMavenOpts())) {
            jvmOptions = mavenModuleProject.getMavenOpts();
        }
        boolean usesPrivateRepository = false;
        String alternateSettings = null;
        if (mavenModuleProject != null) {
            usesPrivateRepository = mavenModuleProject.usesPrivateRepository();
            alternateSettings = mavenModuleProject.getAlternateSettings();
        }
        String pluginCallArgs = sonarInstallation.getPluginCallArgs();
        String installationProperties = sonarInstallation.getAdditionalProperties();
        String jobProperties = sonarPublisher.getJobAdditionalProperties();
        String aditionalProperties = "" + (StringUtils.isNotBlank((String)installationProperties) ? installationProperties : "") + " " + (StringUtils.isNotBlank((String)jobProperties) ? jobProperties : "") + " " + (StringUtils.isNotBlank((String)alternateSettings) ? "-s " + alternateSettings : "");
        return SonarHelper.executeMaven(build, (Launcher)launcher, (BuildListener)listener, (String)(aditionalProperties + " " + "-e -B" + " sonar:sonar"), (String)mavenName, (String)pom, (String)pluginCallArgs, (String)jvmOptions, (boolean)usesPrivateRepository);
    }
}

