/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sonar;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.maven.AbstractMavenProject;
import hudson.maven.MavenModule;
import hudson.maven.MavenModuleSet;
import hudson.maven.ModuleName;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.sonar.BuildSonarAction;
import hudson.plugins.sonar.Messages;
import hudson.plugins.sonar.ProjectSonarAction;
import hudson.plugins.sonar.SonarInstallation;
import hudson.plugins.sonar.SonarPublisher;
import hudson.plugins.sonar.model.LightProjectConfig;
import hudson.plugins.sonar.model.ReportsConfig;
import hudson.plugins.sonar.model.TriggersConfig;
import hudson.plugins.sonar.template.SonarPomGenerator;
import hudson.plugins.sonar.utils.SonarHelper;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Maven;
import hudson.tasks.Notifier;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SonarPublisher
extends Notifier {
    private static final Logger LOG = Logger.getLogger(SonarPublisher.class.getName());
    private Integer configVersion = 1;
    private final String installationName;
    private final String mavenOpts;
    private final String jobAdditionalProperties;
    private TriggersConfig triggers;
    @Deprecated
    private transient Boolean scmBuilds;
    @Deprecated
    private transient Boolean timerBuilds;
    @Deprecated
    private transient Boolean snapshotDependencyBuilds;
    @Deprecated
    private transient Boolean skipIfBuildFails;
    @Deprecated
    private transient Boolean skipOnScm;
    private String mavenInstallationName;
    private String rootPom;
    @Deprecated
    private transient Boolean useSonarLight;
    private LightProjectConfig lightProject;
    @Deprecated
    private transient String groupId;
    @Deprecated
    private transient String artifactId;
    @Deprecated
    private transient String projectName;
    @Deprecated
    private transient String projectVersion;
    @Deprecated
    private transient String projectDescription;
    @Deprecated
    private transient String javaVersion;
    @Deprecated
    private transient String projectSrcDir;
    @Deprecated
    private transient String projectSrcEncoding;
    @Deprecated
    private transient String projectBinDir;
    @Deprecated
    private transient Boolean reuseReports;
    @Deprecated
    private transient String surefireReportsPath;
    @Deprecated
    private transient String coberturaReportPath;
    @Deprecated
    private transient String cloverReportPath;

    public SonarPublisher(String installationName, String jobAdditionalProperties, String mavenOpts) {
        this(installationName, new TriggersConfig(), jobAdditionalProperties, mavenOpts, null, null, null);
    }

    public SonarPublisher(String installationName, TriggersConfig triggers, String jobAdditionalProperties, String mavenOpts) {
        this(installationName, triggers, jobAdditionalProperties, mavenOpts, null, null, null);
    }

    @DataBoundConstructor
    public SonarPublisher(String installationName, TriggersConfig triggers, String jobAdditionalProperties, String mavenOpts, String mavenInstallationName, String rootPom, LightProjectConfig lightProject) {
        this.installationName = installationName;
        this.triggers = triggers;
        this.mavenOpts = mavenOpts;
        this.jobAdditionalProperties = jobAdditionalProperties;
        this.mavenInstallationName = mavenInstallationName;
        this.rootPom = rootPom;
        this.lightProject = lightProject;
    }

    public Object readResolve() {
        if (this.configVersion == null) {
            this.configVersion = 0;
        }
        if (this.configVersion < 1) {
            if (this.scmBuilds != null && this.timerBuilds != null && this.snapshotDependencyBuilds != null && this.skipIfBuildFails != null) {
                this.triggers = new TriggersConfig(this.scmBuilds.booleanValue(), this.timerBuilds.booleanValue(), true, this.snapshotDependencyBuilds.booleanValue(), this.skipIfBuildFails.booleanValue());
            }
            if (this.useSonarLight != null && this.useSonarLight.booleanValue()) {
                ReportsConfig reportsConfig = null;
                if (this.reuseReports != null && this.reuseReports.booleanValue()) {
                    reportsConfig = new ReportsConfig(this.surefireReportsPath, this.coberturaReportPath, this.cloverReportPath);
                }
                this.lightProject = new LightProjectConfig(this.groupId, this.artifactId, this.projectName, this.projectVersion, this.projectDescription, this.javaVersion, this.projectSrcDir, this.projectSrcEncoding, this.projectBinDir, reportsConfig);
            }
            this.configVersion = 1;
        }
        return this;
    }

    public Integer getConfigVersion() {
        return this.configVersion;
    }

    public String getInstallationName() {
        return this.installationName;
    }

    public String getMavenOpts() {
        return this.mavenOpts;
    }

    public String getJobAdditionalProperties() {
        return StringUtils.trimToEmpty((String)this.jobAdditionalProperties);
    }

    public boolean isUseGlobalTriggers() {
        return this.triggers == null;
    }

    public boolean isUseLocalTriggers() {
        return !this.isUseGlobalTriggers();
    }

    public TriggersConfig getTriggers() {
        return this.triggers;
    }

    public String getMavenInstallationName() {
        return this.mavenInstallationName;
    }

    public String getRootPom() {
        return StringUtils.trimToEmpty((String)this.rootPom);
    }

    public boolean isUseSonarLight() {
        return this.lightProject != null;
    }

    public LightProjectConfig getLightProject() {
        return this.lightProject;
    }

    public static boolean isMavenBuilder(AbstractProject currentProject) {
        return currentProject instanceof MavenModuleSet;
    }

    public static List<Maven.MavenInstallation> getMavenInstallations() {
        return Arrays.asList(((Maven.DescriptorImpl)Hudson.getInstance().getDescriptorByType(Maven.DescriptorImpl.class)).getInstallations());
    }

    public SonarInstallation getInstallation() {
        DescriptorImpl sonarDescriptor = (DescriptorImpl)Hudson.getInstance().getDescriptorByType(DescriptorImpl.class);
        if (StringUtils.isEmpty((String)this.getInstallationName()) && sonarDescriptor.getInstallations().length > 0) {
            return sonarDescriptor.getInstallations()[0];
        }
        for (SonarInstallation si : sonarDescriptor.getInstallations()) {
            if (!StringUtils.equals((String)this.getInstallationName(), (String)si.getName())) continue;
            return si;
        }
        return null;
    }

    private boolean isSkip(AbstractBuild<?, ?> build, BuildListener listener, SonarInstallation sonarInstallation) {
        String skipLaunchMsg = sonarInstallation == null ? Messages.SonarPublisher_NoInstallation((Object)this.getInstallationName(), (Object)((DescriptorImpl)Hudson.getInstance().getDescriptorByType(DescriptorImpl.class)).getInstallations().length) : (sonarInstallation.isDisabled() ? Messages.SonarPublisher_InstallDisabled((Object)sonarInstallation.getName()) : (this.isUseGlobalTriggers() ? sonarInstallation.getTriggers().isSkipSonar(build) : this.getTriggers().isSkipSonar(build)));
        if (skipLaunchMsg != null) {
            listener.getLogger().println(skipLaunchMsg);
            return true;
        }
        return false;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        SonarInstallation sonarInstallation = this.getInstallation();
        if (this.isSkip(build, listener, sonarInstallation)) {
            return true;
        }
        build.addAction((Action)new BuildSonarAction());
        boolean sonarSuccess = this.executeSonar(build, launcher, listener, sonarInstallation);
        if (!sonarSuccess) {
            build.setResult(Result.FAILURE);
        }
        LOG.info("Sonar build completed: " + build.getResult());
        return sonarSuccess;
    }

    public MavenModuleSet getMavenProject(AbstractBuild build) {
        return build.getProject() instanceof MavenModuleSet ? (MavenModuleSet)build.getProject() : null;
    }

    private String getPomName(AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
        MavenModuleSet mavenModuleProject = this.getMavenProject(build);
        String pomName = mavenModuleProject != null ? mavenModuleProject.getRootPOM() : this.getRootPom();
        if (StringUtils.isEmpty((String)pomName)) {
            pomName = "pom.xml";
        }
        EnvVars env = build.getEnvironment((TaskListener)listener);
        pomName = env.expand(pomName);
        return pomName;
    }

    private boolean executeSonar(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener, SonarInstallation sonarInstallation) {
        try {
            String pomName = this.getPomName(build, listener);
            FilePath root = build.getModuleRoot();
            if (this.isUseSonarLight()) {
                LOG.info("Generating " + pomName);
                SonarPomGenerator.generatePomForNonMavenProject((LightProjectConfig)this.getLightProject(), (FilePath)root, (String)pomName);
            }
            return SonarHelper.executeMaven(build, (Launcher)launcher, (BuildListener)listener, (String)this.getMavenInstallationName(), (String)pomName, (SonarInstallation)sonarInstallation, (SonarPublisher)this);
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError("command execution failed"));
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (Exception e) {
            e.printStackTrace(listener.fatalError("command execution failed"));
            return false;
        }
    }

    protected String getSonarUrl(AbstractProject<?, ?> project) {
        MavenModuleSet mms;
        MavenModule rootModule;
        AbstractMavenProject mavenProject;
        SonarInstallation sonarInstallation = this.getInstallation();
        if (sonarInstallation == null) {
            return null;
        }
        String url = sonarInstallation.getServerLink();
        if (project instanceof AbstractMavenProject && (mavenProject = (AbstractMavenProject)project).getRootProject() instanceof MavenModuleSet && (rootModule = (mms = (MavenModuleSet)mavenProject.getRootProject()).getRootModule()) != null) {
            ModuleName moduleName = rootModule.getModuleName();
            url = sonarInstallation.getProjectLink(moduleName.groupId, moduleName.artifactId);
        }
        if (this.isUseSonarLight()) {
            url = sonarInstallation.getProjectLink(this.lightProject.getGroupId(), this.lightProject.getArtifactId());
        }
        return url;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new ProjectSonarAction(this.getSonarUrl(project));
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }
}

