/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sonar.template;

import hudson.FilePath;
import hudson.plugins.sonar.model.LightProjectConfig;
import hudson.plugins.sonar.model.ReportsConfig;
import hudson.plugins.sonar.template.SimpleTemplate;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public final class SonarPomGenerator {
    public static void generatePomForNonMavenProject(LightProjectConfig project, FilePath root, String pomName) throws IOException, InterruptedException {
        SimpleTemplate pomTemplate = new SimpleTemplate("hudson/plugins/sonar/sonar-light-pom.template");
        pomTemplate.setAttribute("groupId", project.getGroupId());
        pomTemplate.setAttribute("artifactId", project.getArtifactId());
        pomTemplate.setAttribute("projectName", project.getProjectName());
        pomTemplate.setAttribute("projectVersion", StringUtils.isEmpty((String)project.getProjectVersion()) ? "1.0" : project.getProjectVersion());
        pomTemplate.setAttribute("javaVersion", StringUtils.isEmpty((String)project.getJavaVersion()) ? "1.5" : project.getJavaVersion());
        List srcDirs = SonarPomGenerator.getProjectSrcDirsList((String)project.getProjectSrcDir());
        boolean multiSources = srcDirs.size() > 1;
        SonarPomGenerator.setPomElement((String)"sourceDirectory", (String)(srcDirs.size() == 0 ? "src" : (String)srcDirs.get(0)), (SimpleTemplate)pomTemplate);
        pomTemplate.setAttribute("srcDirsPlugin", multiSources ? SonarPomGenerator.generateSrcDirsPluginTemplate((List)srcDirs).toString() : "");
        SonarPomGenerator.setPomElement((String)"project.build.sourceEncoding", (String)project.getProjectSrcEncoding(), (SimpleTemplate)pomTemplate);
        SonarPomGenerator.setPomElement((String)"encoding", (String)project.getProjectSrcEncoding(), (SimpleTemplate)pomTemplate);
        SonarPomGenerator.setPomElement((String)"description", (String)project.getProjectDescription(), (SimpleTemplate)pomTemplate);
        SonarPomGenerator.setPomElement((String)"sonar.phase", (String)(multiSources ? "generate-sources" : ""), (SimpleTemplate)pomTemplate);
        SonarPomGenerator.setPomElement((String)"outputDirectory", (String)project.getProjectBinDir(), (SimpleTemplate)pomTemplate);
        ReportsConfig reports = project.isReuseReports() ? project.getReports() : new ReportsConfig();
        SonarPomGenerator.setPomElement((String)"sonar.dynamicAnalysis", (String)(project.isReuseReports() ? "reuseReports" : "false"), (boolean)true, (SimpleTemplate)pomTemplate);
        SonarPomGenerator.setPomElement((String)"sonar.surefire.reportsPath", (String)reports.getSurefireReportsPath(), (boolean)project.isReuseReports(), (SimpleTemplate)pomTemplate);
        SonarPomGenerator.setPomElement((String)"sonar.cobertura.reportPath", (String)reports.getCoberturaReportPath(), (boolean)project.isReuseReports(), (SimpleTemplate)pomTemplate);
        SonarPomGenerator.setPomElement((String)"sonar.clover.reportPath", (String)reports.getCloverReportPath(), (boolean)project.isReuseReports(), (SimpleTemplate)pomTemplate);
        pomTemplate.write(root, pomName);
    }

    private static SimpleTemplate generateSrcDirsPluginTemplate(List<String> srcDirs) throws IOException, InterruptedException {
        SimpleTemplate srcTemplate = new SimpleTemplate("hudson/plugins/sonar/sonar-multi-sources.template");
        StringBuffer sourcesXml = new StringBuffer();
        for (int i = 1; i < srcDirs.size(); ++i) {
            sourcesXml.append("<source><![CDATA[").append(StringUtils.trim((String)srcDirs.get(i))).append("]]></source>\n");
        }
        srcTemplate.setAttribute("sources", sourcesXml.toString());
        return srcTemplate;
    }

    private static void setPomElement(String tagName, String tagValue, SimpleTemplate template) {
        SonarPomGenerator.setPomElement((String)tagName, (String)tagValue, (boolean)true, (SimpleTemplate)template);
    }

    private static void setPomElement(String tagName, String tagValue, boolean enabled, SimpleTemplate template) {
        String tagContent = enabled && StringUtils.isNotBlank((String)tagValue) ? "<" + tagName + "><![CDATA[" + tagValue + "]]></" + tagName + ">" : "";
        template.setAttribute(tagName, tagContent);
    }

    private static List<String> getProjectSrcDirsList(String src) {
        String[] dirs = StringUtils.split((String)src, (char)',');
        return Arrays.asList(dirs);
    }

    private SonarPomGenerator() {
    }
}

