/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sonar.utils;

import hudson.Launcher;
import hudson.maven.MavenModuleSet;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.plugins.sonar.SonarInstallation;
import hudson.plugins.sonar.SonarPublisher;
import hudson.plugins.sonar.utils.ExtendedArgumentListBuilder;
import hudson.tasks.Maven;
import hudson.util.ArgumentListBuilder;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SonarMaven
extends Maven {
    private static final String TARGET = "-e -B sonar:sonar";
    private SonarInstallation sonarInstallation;

    public SonarMaven(String targets, String name, String pom, String jvmOptions, boolean usePrivateRepository, SonarInstallation sonarInstallation) {
        super(targets + " " + TARGET, name, pom, "", jvmOptions, usePrivateRepository);
        this.sonarInstallation = sonarInstallation;
    }

    protected void wrapUpArguments(ArgumentListBuilder args, String normalizedTarget, AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        ExtendedArgumentListBuilder argsBuilder = new ExtendedArgumentListBuilder(args, launcher.isUnix());
        argsBuilder.append("sonar.jdbc.driver", this.sonarInstallation.getDatabaseDriver());
        argsBuilder.append("sonar.jdbc.url", this.sonarInstallation.getDatabaseUrl());
        argsBuilder.appendMasked("sonar.jdbc.username", this.sonarInstallation.getDatabaseLogin());
        argsBuilder.appendMasked("sonar.jdbc.password", this.sonarInstallation.getDatabasePassword());
        argsBuilder.append("sonar.host.url", this.sonarInstallation.getServerUrl());
    }

    public Maven.DescriptorImpl getDescriptor() {
        return (Maven.DescriptorImpl)Hudson.getInstance().getDescriptorOrDie(Maven.class);
    }

    public static boolean executeMaven(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener, String mavenName, String pom, SonarInstallation sonarInstallation, SonarPublisher sonarPublisher) throws IOException, InterruptedException {
        MavenModuleSet mavenModuleProject = sonarPublisher.getMavenProject(build);
        String jvmOptions = sonarPublisher.getMavenOpts();
        if (StringUtils.isEmpty((String)jvmOptions) && mavenModuleProject != null && StringUtils.isNotEmpty((String)mavenModuleProject.getMavenOpts())) {
            jvmOptions = mavenModuleProject.getMavenOpts();
        }
        boolean usesPrivateRepository = false;
        String alternateSettings = null;
        if (mavenModuleProject != null) {
            usesPrivateRepository = mavenModuleProject.usesPrivateRepository();
            alternateSettings = mavenModuleProject.getAlternateSettings();
        }
        String installationProperties = sonarInstallation.getAdditionalProperties();
        String jobProperties = sonarPublisher.getJobAdditionalProperties();
        String aditionalProperties = "" + (StringUtils.isNotBlank((String)installationProperties) ? installationProperties : "") + " " + (StringUtils.isNotBlank((String)jobProperties) ? jobProperties : "") + " " + (StringUtils.isNotBlank((String)alternateSettings) ? "-s " + alternateSettings : "");
        return new SonarMaven(aditionalProperties, mavenName, pom, jvmOptions, usesPrivateRepository, sonarInstallation).perform(build, launcher, listener);
    }
}

