/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sonar;

import hudson.plugins.sonar.model.TriggersConfig;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class SonarInstallation {
    private final String name;
    private final boolean disabled;
    private final String serverUrl;
    private String serverPublicUrl;
    private final String databaseUrl;
    private final String databaseDriver;
    private final String databaseLogin;
    private final String databasePassword;
    private final String additionalProperties;
    private TriggersConfig triggers;

    public SonarInstallation(String name) {
        this(name, false, null, null, null, null, null, null, null, null);
    }

    @DataBoundConstructor
    public SonarInstallation(String name, boolean disabled, String serverUrl, String serverPublicUrl, String databaseUrl, String databaseDriver, String databaseLogin, String databasePassword, String additionalProperties, TriggersConfig triggers) {
        this.name = name;
        this.disabled = disabled;
        this.serverUrl = serverUrl;
        this.serverPublicUrl = serverPublicUrl;
        this.databaseUrl = databaseUrl;
        this.databaseDriver = databaseDriver;
        this.databaseLogin = databaseLogin;
        this.databasePassword = databasePassword;
        this.additionalProperties = additionalProperties;
        this.triggers = triggers;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getServerPublicUrl() {
        return this.serverPublicUrl;
    }

    public void setServerPublicUrl(String serverPublicUrl) {
        this.serverPublicUrl = serverPublicUrl;
    }

    public String getDatabaseUrl() {
        return this.databaseUrl;
    }

    public String getDatabaseDriver() {
        return this.databaseDriver;
    }

    public String getDatabaseLogin() {
        return this.databaseLogin;
    }

    public String getDatabasePassword() {
        return this.databasePassword;
    }

    public String getAdditionalProperties() {
        return this.additionalProperties;
    }

    public TriggersConfig getTriggers() {
        if (this.triggers == null) {
            this.triggers = new TriggersConfig();
        }
        return this.triggers;
    }

    public String getServerLink() {
        String url = StringUtils.defaultIfEmpty((String)StringUtils.trimToEmpty((String)this.getServerPublicUrl()), (String)StringUtils.trimToEmpty((String)this.getServerUrl()));
        url = StringUtils.defaultIfEmpty((String)url, (String)"http://localhost:9000");
        return StringUtils.chomp((String)url, (String)"/");
    }

    private String getServerLink(String prefix, String groupId, String artifactId) {
        return this.getServerLink(prefix, groupId, artifactId, null);
    }

    private String getServerLink(String prefix, String groupId, String artifactId, String branch) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getServerLink()).append(prefix).append(groupId).append(':').append(artifactId);
        if (StringUtils.isNotEmpty((String)branch)) {
            builder.append(':').append(branch);
        }
        return builder.toString();
    }

    public String getProjectLink(String groupId, String artifactId, String branch) {
        return this.getServerLink("/project/index/", groupId, artifactId, branch);
    }

    public String getComponentLink(String groupId, String artifactId) {
        return this.getServerLink("/components/index/", groupId, artifactId);
    }
}

