/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sonar.template;

import hudson.FilePath;
import hudson.plugins.sonar.template.TemplateException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import org.apache.commons.io.IOUtils;

public class SimpleTemplate {
    private String template;

    public SimpleTemplate(String path) {
        InputStream stream = null;
        try {
            stream = this.getClass().getClassLoader().getResourceAsStream(path);
            if (stream == null) {
                throw new TemplateException("Template not found in classloader: " + path);
            }
            this.template = IOUtils.toString((InputStream)stream);
        }
        catch (IOException e) {
            try {
                throw new TemplateException("Could not read template: " + path, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)stream);
    }

    public void setAttribute(String key, String value) {
        this.template = this.template.replace('$' + key + '$', value);
    }

    public String toString() {
        return this.template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(FilePath path, String pomName) throws IOException, InterruptedException {
        FilePath pom = path.child(pomName);
        OutputStreamWriter outputStream = new OutputStreamWriter(pom.write());
        try {
            outputStream.write(this.template);
        }
        finally {
            outputStream.close();
        }
    }
}

