/*
 * Sonar is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * Sonar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sonar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02
 */
package hudson.plugins.sonar.template;

import hudson.FilePath;
import org.apache.commons.io.IOUtils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;

import static org.apache.commons.io.IOUtils.closeQuietly;

public class SimpleTemplate {
  private String template;

  public SimpleTemplate(String path) {
    InputStream stream = null;
    try {
      stream = getClass().getClassLoader().getResourceAsStream(path);
      if (stream == null) {
        throw new TemplateException("Template not found in classloader: " + path);
      }
      template = IOUtils.toString(stream);
    }
    catch (IOException e) {
      throw new TemplateException("Could not read template: " + path, e);
    }
    finally {
      closeQuietly(stream);
    }
  }

  public void setAttribute(String key, String value) {
    template = template.replace('$' + key + '$', value);
  }

  @Override
  public String toString() {
    return template;
  }

  public void write(FilePath path, String pomName) throws IOException, InterruptedException {
    FilePath pom = path.child(pomName);
    OutputStreamWriter outputStream = new OutputStreamWriter(pom.write());
    try {
      outputStream.write(template);
    }
    finally {
      outputStream.close();
    }
  }
}
