/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sonar.template;

import hudson.FilePath;
import hudson.plugins.sonar.model.LightProjectConfig;
import hudson.plugins.sonar.model.ReportsConfig;
import hudson.plugins.sonar.template.SimpleTemplate;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SonarPomGenerator {
    public static void generatePomForNonMavenProject(LightProjectConfig project, FilePath root, String pomName) throws IOException, InterruptedException {
        SimpleTemplate pomTemplate = new SimpleTemplate("hudson/plugins/sonar/sonar-light-pom.template");
        pomTemplate.setAttribute("groupId", project.getGroupId());
        pomTemplate.setAttribute("artifactId", project.getArtifactId());
        pomTemplate.setAttribute("projectName", project.getProjectName());
        pomTemplate.setAttribute("projectVersion", StringUtils.isEmpty((String)project.getProjectVersion()) ? "1.0" : project.getProjectVersion());
        pomTemplate.setAttribute("javaVersion", StringUtils.isEmpty((String)project.getJavaVersion()) ? "1.5" : project.getJavaVersion());
        List<String> srcDirs = SonarPomGenerator.getProjectSrcDirsList(project.getProjectSrcDir());
        boolean multiSources = srcDirs.size() > 1;
        SonarPomGenerator.setPomElement("sourceDirectory", srcDirs.size() == 0 ? "src" : srcDirs.get(0), pomTemplate);
        pomTemplate.setAttribute("srcDirsPlugin", multiSources ? SonarPomGenerator.generateSrcDirsPluginTemplate(srcDirs).toString() : "");
        SonarPomGenerator.setPomElement("project.build.sourceEncoding", project.getProjectSrcEncoding(), pomTemplate);
        SonarPomGenerator.setPomElement("encoding", project.getProjectSrcEncoding(), pomTemplate);
        SonarPomGenerator.setPomElement("description", project.getProjectDescription(), pomTemplate);
        SonarPomGenerator.setPomElement("sonar.phase", multiSources ? "generate-sources" : "", pomTemplate);
        SonarPomGenerator.setPomElement("outputDirectory", project.getProjectBinDir(), pomTemplate);
        ReportsConfig reports = project.isReuseReports() ? project.getReports() : new ReportsConfig();
        SonarPomGenerator.setPomElement("sonar.dynamicAnalysis", project.isReuseReports() ? "reuseReports" : "false", true, pomTemplate);
        SonarPomGenerator.setPomElement("sonar.surefire.reportsPath", reports.getSurefireReportsPath(), project.isReuseReports(), pomTemplate);
        SonarPomGenerator.setPomElement("sonar.cobertura.reportPath", reports.getCoberturaReportPath(), project.isReuseReports(), pomTemplate);
        SonarPomGenerator.setPomElement("sonar.clover.reportPath", reports.getCloverReportPath(), project.isReuseReports(), pomTemplate);
        pomTemplate.write(root, pomName);
    }

    private static SimpleTemplate generateSrcDirsPluginTemplate(List<String> srcDirs) throws IOException, InterruptedException {
        SimpleTemplate srcTemplate = new SimpleTemplate("hudson/plugins/sonar/sonar-multi-sources.template");
        StringBuffer sourcesXml = new StringBuffer();
        for (int i = 1; i < srcDirs.size(); ++i) {
            sourcesXml.append("<source><![CDATA[").append(StringUtils.trim((String)srcDirs.get(i))).append("]]></source>\n");
        }
        srcTemplate.setAttribute("sources", sourcesXml.toString());
        return srcTemplate;
    }

    private static void setPomElement(String tagName, String tagValue, SimpleTemplate template) {
        SonarPomGenerator.setPomElement(tagName, tagValue, true, template);
    }

    private static void setPomElement(String tagName, String tagValue, boolean enabled, SimpleTemplate template) {
        String tagContent = enabled && StringUtils.isNotBlank((String)tagValue) ? "<" + tagName + "><![CDATA[" + tagValue + "]]></" + tagName + ">" : "";
        template.setAttribute(tagName, tagContent);
    }

    private static List<String> getProjectSrcDirsList(String src) {
        String[] dirs = StringUtils.split((String)src, (char)',');
        return Arrays.asList(dirs);
    }

    private SonarPomGenerator() {
    }
}

