/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sonar.utils;

import hudson.FilePath;
import hudson.Launcher;
import hudson.maven.MavenModuleSet;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.plugins.sonar.SonarInstallation;
import hudson.plugins.sonar.SonarPublisher;
import hudson.plugins.sonar.utils.ExtendedArgumentListBuilder;
import hudson.tasks.Maven;
import hudson.util.ArgumentListBuilder;
import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public final class SonarMaven
extends Maven {
    private static final String TARGET = "-e -B";
    private final SonarPublisher publisher;
    private final String additionalProperties;

    public SonarMaven(String additionalProperties, String name, String pom, String jvmOptions, boolean usePrivateRepository, SonarPublisher publisher) {
        super(SonarMaven.getTarget((SonarInstallation)publisher.getInstallation()), name, pom, "", jvmOptions, usePrivateRepository);
        this.additionalProperties = additionalProperties;
        this.publisher = publisher;
    }

    static String getTarget(SonarInstallation installation) {
        if (StringUtils.isBlank((String)installation.getMojoVersion())) {
            return "-e -B sonar:sonar";
        }
        return "-e -B org.codehaus.mojo:sonar-maven-plugin:" + installation.getMojoVersion() + ":sonar";
    }

    private SonarInstallation getInstallation() {
        return this.publisher.getInstallation();
    }

    protected void wrapUpArguments(ArgumentListBuilder args, String normalizedTarget, AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        args.addTokenized(this.additionalProperties);
        ExtendedArgumentListBuilder argsBuilder = new ExtendedArgumentListBuilder(args, launcher.isUnix());
        argsBuilder.append("sonar.jdbc.driver", this.getInstallation().getDatabaseDriver());
        argsBuilder.append("sonar.jdbc.url", this.getInstallation().getDatabaseUrl());
        argsBuilder.appendMasked("sonar.jdbc.username", this.getInstallation().getDatabaseLogin());
        argsBuilder.appendMasked("sonar.jdbc.password", this.getInstallation().getDatabasePassword());
        argsBuilder.append("sonar.host.url", this.getInstallation().getServerUrl());
        argsBuilder.append("sonar.branch", this.publisher.getBranch());
        argsBuilder.append("sonar.language", this.publisher.getLanguage());
    }

    public Maven.DescriptorImpl getDescriptor() {
        return (Maven.DescriptorImpl)Hudson.getInstance().getDescriptorOrDie(Maven.class);
    }

    public static boolean executeMaven(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener, String mavenName, String pom, SonarInstallation sonarInstallation, SonarPublisher sonarPublisher) throws IOException, InterruptedException {
        MavenModuleSet mavenModuleProject = sonarPublisher.getMavenProject(build);
        String jvmOptions = sonarPublisher.getMavenOpts();
        if (StringUtils.isEmpty((String)jvmOptions) && mavenModuleProject != null && StringUtils.isNotEmpty((String)mavenModuleProject.getMavenOpts())) {
            jvmOptions = mavenModuleProject.getMavenOpts();
        }
        boolean usesPrivateRepository = false;
        String alternateSettings = null;
        if (mavenModuleProject != null) {
            usesPrivateRepository = mavenModuleProject.usesPrivateRepository();
            alternateSettings = mavenModuleProject.getAlternateSettings();
            if (alternateSettings != null && !SonarMaven.isAbsolute((String)alternateSettings)) {
                FilePath mrSettings = build.getModuleRoot().child(alternateSettings);
                FilePath wsSettings = build.getWorkspace().child(alternateSettings);
                if (!wsSettings.exists() && mrSettings.exists()) {
                    wsSettings = mrSettings;
                }
                alternateSettings = wsSettings.getRemote();
            }
        }
        String installationProperties = sonarInstallation.getAdditionalProperties();
        String jobProperties = sonarPublisher.getJobAdditionalProperties();
        String aditionalProperties = "" + (StringUtils.isNotBlank((String)installationProperties) ? installationProperties : "") + " " + (StringUtils.isNotBlank((String)jobProperties) ? jobProperties : "") + " " + (StringUtils.isNotBlank((String)alternateSettings) ? "-s " + alternateSettings : "");
        pom = build.getModuleRoot().child(pom).getRemote();
        return new SonarMaven(aditionalProperties, mavenName, pom, jvmOptions, usesPrivateRepository, sonarPublisher).perform(build, launcher, listener);
    }

    private static boolean isAbsolute(String path) {
        Pattern drivePattern = Pattern.compile("[A-Za-z]:[\\\\/].*");
        return path.startsWith("/") || drivePattern.matcher(path).matches();
    }
}

