/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sonar;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Executor;
import hudson.model.JDK;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.plugins.sonar.SonarInstallation;
import hudson.plugins.sonar.SonarRunnerBuilder;
import hudson.util.ArgumentListBuilder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class SonarRunner {
    private final AbstractProject project;
    private final Launcher launcher;
    private final EnvVars envVars;
    private final FilePath workDir;
    private FilePath runnerJar;
    private FilePath bootstrapperJar;

    public SonarRunner(AbstractProject project, Launcher launcher, EnvVars envVars, FilePath workDir) {
        this.project = project;
        this.launcher = launcher;
        this.envVars = envVars;
        this.workDir = workDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int launch(BuildListener listener, SonarRunnerBuilder conf) throws IOException, InterruptedException {
        try {
            this.extract();
            ArgumentListBuilder args = this.buildCmdLine(listener, conf);
            int n = this.launcher.launch().cmds(args).envs((Map)this.envVars).stdout((TaskListener)listener).pwd(this.workDir).join();
            return n;
        }
        finally {
            this.cleanup();
        }
    }

    ArgumentListBuilder buildCmdLine(BuildListener listener, SonarRunnerBuilder conf) throws IOException, InterruptedException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(this.getJavaExecutable(listener));
        args.addTokenized(this.envVars.expand(conf.getJavaOpts()));
        args.add("-cp");
        args.add(this.runnerJar.getRemote() + this.getClasspathDelimiter() + this.bootstrapperJar.getRemote());
        args.add("org.sonar.runner.Main");
        SonarInstallation si = conf.getSonarInstallation();
        if (si != null) {
            SonarRunner.appendArg(args, "sonar.jdbc.driver", si.getDatabaseDriver());
            SonarRunner.appendArg(args, "sonar.jdbc.url", si.getDatabaseUrl());
            SonarRunner.appendMaskedArg(args, "sonar.jdbc.username", si.getDatabaseLogin());
            SonarRunner.appendMaskedArg(args, "sonar.jdbc.password", si.getDatabasePassword());
            SonarRunner.appendArg(args, "sonar.host.url", si.getServerUrl());
        }
        SonarRunner.appendArg(args, "project.settings", conf.getProject());
        Properties p = new Properties();
        p.load(new ByteArrayInputStream(conf.getProperties().getBytes()));
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            args.add("-D" + entry.getKey() + "=" + entry.getValue().toString());
        }
        return args;
    }

    private static void appendArg(ArgumentListBuilder args, String name, String value) {
        if (StringUtils.isNotEmpty((String)(value = StringUtils.trimToEmpty((String)value)))) {
            args.add("-D" + name + "=" + value);
        }
    }

    private static void appendMaskedArg(ArgumentListBuilder args, String name, String value) {
        if (StringUtils.isNotEmpty((String)(value = StringUtils.trimToEmpty((String)value)))) {
            args.addMasked("-D" + name + "=" + value);
        }
    }

    void extract() throws IOException, InterruptedException {
        this.runnerJar = this.workDir.createTempFile("sonar-runner", ".jar");
        this.runnerJar.copyFrom(this.getClass().getClassLoader().getResource("sonar-runner.jar"));
        this.bootstrapperJar = this.workDir.createTempFile("sonar-batch-bootstrapper", ".jar");
        this.bootstrapperJar.copyFrom(this.getClass().getClassLoader().getResource("sonar-batch-bootstrapper.jar"));
    }

    void cleanup() throws IOException, InterruptedException {
        if (this.runnerJar != null) {
            this.runnerJar.delete();
        }
        if (this.bootstrapperJar != null) {
            this.bootstrapperJar.delete();
        }
    }

    char getClasspathDelimiter() {
        return this.launcher.isUnix() ? (char)':' : ';';
    }

    private String getJavaExecutable(BuildListener listener) throws IOException, InterruptedException {
        JDK jdk = this.project.getJDK();
        if (jdk != null) {
            jdk = jdk.forNode(this.getCurrentNode(), (TaskListener)listener).forEnvironment(this.envVars);
        }
        return jdk == null ? "java" : jdk.getHome() + "/bin/java";
    }

    private Node getCurrentNode() {
        return Executor.currentExecutor().getOwner().getNode();
    }
}

