/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sonar;

import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.plugins.sonar.BuildSonarAction;
import hudson.plugins.sonar.Messages;
import hudson.plugins.sonar.SonarInstallation;
import hudson.plugins.sonar.SonarRunner;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.IOException;
import org.kohsuke.stapler.DataBoundConstructor;

public class SonarRunnerBuilder
extends Builder {
    private final String installationName;
    private final String project;
    private final String properties;
    private final String javaOpts;

    @DataBoundConstructor
    public SonarRunnerBuilder(String installationName, String project, String properties, String javaOpts) {
        this.installationName = installationName;
        this.javaOpts = javaOpts;
        this.project = project;
        this.properties = properties;
    }

    public String getInstallationName() {
        return Util.fixNull((String)this.installationName);
    }

    public String getProject() {
        return Util.fixNull((String)this.project);
    }

    public String getProperties() {
        return Util.fixNull((String)this.properties);
    }

    public String getJavaOpts() {
        return Util.fixNull((String)this.javaOpts);
    }

    public SonarInstallation getSonarInstallation() {
        return SonarInstallation.get(this.getInstallationName());
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        SonarInstallation sonarInstallation = this.getSonarInstallation();
        String skipLaunchMsg = sonarInstallation == null ? Messages.SonarPublisher_NoInstallation(this.getInstallationName(), SonarInstallation.all().length) : (sonarInstallation.isDisabled() ? Messages.SonarPublisher_InstallDisabled(sonarInstallation.getName()) : null);
        if (skipLaunchMsg != null) {
            listener.getLogger().println(skipLaunchMsg);
            return true;
        }
        SonarRunner sonarRunner = new SonarRunner(build.getProject(), launcher, build.getEnvironment((TaskListener)listener), build.getWorkspace());
        if (build.getAction(BuildSonarAction.class) == null) {
            build.addAction((Action)new BuildSonarAction());
        }
        return sonarRunner.launch(listener, this) == 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public SonarInstallation[] getSonarInstallations() {
            return SonarInstallation.all();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Invoke Standalone Sonar Analysis";
        }
    }
}

