/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sonar;

import hudson.Util;
import hudson.model.Hudson;
import hudson.plugins.sonar.SonarPublisher;
import hudson.plugins.sonar.model.TriggersConfig;
import hudson.util.Scrambler;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * Exception performing whole class analysis ignored.
 */
public class SonarInstallation {
    private final String name;
    private final boolean disabled;
    private final String serverUrl;
    private String serverPublicUrl;
    private String mojoVersion;
    private final String databaseUrl;
    private final String databaseDriver;
    private final String databaseLogin;
    private String databasePassword;
    private final String additionalProperties;
    private TriggersConfig triggers;
    private String sonarLogin;
    private String sonarPassword;

    public static final SonarInstallation[] all() {
        Hudson hudson = Hudson.getInstance();
        if (hudson == null) {
            return new SonarInstallation[0];
        }
        SonarPublisher.DescriptorImpl sonarDescriptor = (SonarPublisher.DescriptorImpl)Hudson.getInstance().getDescriptorByType(SonarPublisher.DescriptorImpl.class);
        return sonarDescriptor.getInstallations();
    }

    public static final SonarInstallation get(String name) {
        SonarInstallation[] available = SonarInstallation.all();
        if (StringUtils.isEmpty((String)name) && available.length > 0) {
            return available[0];
        }
        for (SonarInstallation si : available) {
            if (!StringUtils.equals((String)name, (String)si.getName())) continue;
            return si;
        }
        return null;
    }

    @Deprecated
    public SonarInstallation(String name) {
        this(name, false, null, null, null, null, null, null, null, null, null);
    }

    @Deprecated
    public SonarInstallation(String name, boolean disabled, String serverUrl, String serverPublicUrl, String databaseUrl, String databaseDriver, String databaseLogin, String databasePassword, String mojoVersion, String additionalProperties, TriggersConfig triggers) {
        this(name, disabled, serverUrl, serverPublicUrl, databaseUrl, databaseDriver, databaseLogin, databasePassword, mojoVersion, additionalProperties, triggers, null, null);
    }

    @DataBoundConstructor
    public SonarInstallation(String name, boolean disabled, String serverUrl, String serverPublicUrl, String databaseUrl, String databaseDriver, String databaseLogin, String databasePassword, String mojoVersion, String additionalProperties, TriggersConfig triggers, String sonarLogin, String sonarPassword) {
        this.name = name;
        this.disabled = disabled;
        this.serverUrl = serverUrl;
        this.serverPublicUrl = serverPublicUrl;
        this.databaseUrl = databaseUrl;
        this.databaseDriver = databaseDriver;
        this.databaseLogin = databaseLogin;
        this.setDatabasePassword(databasePassword);
        this.mojoVersion = mojoVersion;
        this.additionalProperties = additionalProperties;
        this.triggers = triggers;
        this.sonarLogin = sonarLogin;
        this.setSonarPassword(sonarPassword);
    }

    public String getName() {
        return this.name;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getServerPublicUrl() {
        return this.serverPublicUrl;
    }

    public void setServerPublicUrl(String serverPublicUrl) {
        this.serverPublicUrl = serverPublicUrl;
    }

    public String getMojoVersion() {
        return this.mojoVersion;
    }

    public String getDatabaseUrl() {
        return this.databaseUrl;
    }

    public String getDatabaseDriver() {
        return this.databaseDriver;
    }

    public String getDatabaseLogin() {
        return this.databaseLogin;
    }

    public String getDatabasePassword() {
        return Scrambler.descramble((String)this.databasePassword);
    }

    public final void setDatabasePassword(String password) {
        this.databasePassword = Scrambler.scramble((String)Util.fixEmptyAndTrim((String)password));
    }

    public String getScrambledDatabasePassword() {
        return this.databasePassword;
    }

    public String getAdditionalProperties() {
        return this.additionalProperties;
    }

    public TriggersConfig getTriggers() {
        if (this.triggers == null) {
            this.triggers = new TriggersConfig();
        }
        return this.triggers;
    }

    public String getServerLink() {
        String url = StringUtils.defaultIfEmpty((String)StringUtils.trimToEmpty((String)this.getServerPublicUrl()), (String)StringUtils.trimToEmpty((String)this.getServerUrl()));
        url = StringUtils.defaultIfEmpty((String)url, (String)"http://localhost:9000");
        return StringUtils.chomp((String)url, (String)"/");
    }

    private String getServerLink(String prefix, String groupId, String artifactId) {
        return this.getServerLink(prefix, groupId, artifactId, null);
    }

    private String getServerLink(String prefix, String groupId, String artifactId, String branch) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getServerLink()).append(prefix).append(groupId).append(':').append(artifactId);
        if (StringUtils.isNotEmpty((String)branch)) {
            builder.append(':').append(branch);
        }
        return builder.toString();
    }

    public String getProjectLink(String groupId, String artifactId, String branch) {
        return this.getServerLink("/project/index/", groupId, artifactId, branch);
    }

    public String getComponentLink(String groupId, String artifactId) {
        return this.getServerLink("/components/index/", groupId, artifactId);
    }

    public String getSonarLogin() {
        return this.sonarLogin;
    }

    public String getSonarPassword() {
        return Scrambler.descramble((String)this.sonarPassword);
    }

    public final void setSonarPassword(String sonarPassword) {
        this.sonarPassword = Scrambler.scramble((String)Util.fixEmptyAndTrim((String)sonarPassword));
    }
}

