/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sonar;

import hudson.Plugin;
import hudson.model.Hudson;
import hudson.plugins.sonar.SonarInstallation;
import hudson.plugins.sonar.SonarPublisher;
import java.io.IOException;

public class SonarPlugin
extends Plugin {
    private Integer configVersion;

    public void postInitialize() throws Exception {
        this.load();
        if (this.configVersion == null) {
            this.configVersion = 0;
        }
        if (this.configVersion < 1) {
            this.migrateToVersion1();
        }
    }

    private void migrateToVersion1() throws IOException {
        SonarPublisher.DescriptorImpl sonarDescriptor = (SonarPublisher.DescriptorImpl)Hudson.getInstance().getDescriptorByType(SonarPublisher.DescriptorImpl.class);
        SonarInstallation[] installations = sonarDescriptor.getInstallations();
        if (installations != null) {
            for (SonarInstallation installation : installations) {
                installation.setDatabasePassword(installation.getScrambledDatabasePassword());
                sonarDescriptor.save();
            }
        }
        this.configVersion = 1;
        this.save();
    }
}

