/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sonar;

import com.google.common.annotations.VisibleForTesting;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.model.JDK;
import hudson.model.TaskListener;
import hudson.plugins.sonar.BuildSonarAction;
import hudson.plugins.sonar.Messages;
import hudson.plugins.sonar.SonarInstallation;
import hudson.plugins.sonar.SonarRunnerBuilder;
import hudson.plugins.sonar.SonarRunnerInstallation;
import hudson.plugins.sonar.utils.ExtendedArgumentListBuilder;
import hudson.plugins.sonar.utils.Logger;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * Exception performing whole class analysis ignored.
 */
public class SonarRunnerBuilder
extends Builder {
    private final String installationName;
    private final String project;
    private final String properties;
    private final String javaOpts;
    private String jdk;
    private final String sonarRunnerName;

    @Deprecated
    public SonarRunnerBuilder(String installationName, String project, String properties, String javaOpts) {
        this(installationName, null, project, properties, javaOpts, null);
    }

    @Deprecated
    public SonarRunnerBuilder(String installationName, String sonarRunnerName, String project, String properties, String javaOpts) {
        this(installationName, sonarRunnerName, project, properties, javaOpts, null);
    }

    @DataBoundConstructor
    public SonarRunnerBuilder(String installationName, String sonarRunnerName, String project, String properties, String javaOpts, String jdk) {
        this.installationName = installationName;
        this.sonarRunnerName = sonarRunnerName;
        this.javaOpts = javaOpts;
        this.project = project;
        this.properties = properties;
        this.jdk = jdk;
    }

    public String getInstallationName() {
        return Util.fixNull((String)this.installationName);
    }

    public String getSonarRunnerName() {
        return Util.fixNull((String)this.sonarRunnerName);
    }

    public JDK getJDK() {
        return Hudson.getInstance().getJDK(this.jdk);
    }

    public String getProject() {
        return Util.fixNull((String)this.project);
    }

    public String getProperties() {
        return Util.fixNull((String)this.properties);
    }

    public String getJavaOpts() {
        return Util.fixNull((String)this.javaOpts);
    }

    public SonarInstallation getSonarInstallation() {
        return SonarInstallation.get((String)this.getInstallationName());
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public SonarRunnerInstallation getSonarRunnerInstallation() {
        for (SonarRunnerInstallation sri : this.getDescriptor().getSonarRunnerInstallations()) {
            if (this.sonarRunnerName == null || !this.sonarRunnerName.equals(sri.getName())) continue;
            return sri;
        }
        if (this.getDescriptor().getSonarRunnerInstallations().length > 0) {
            return this.getDescriptor().getSonarRunnerInstallations()[0];
        }
        return null;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        if (!SonarRunnerBuilder.isSonarInstallationValid((String)this.getInstallationName(), (BuildListener)listener)) {
            return false;
        }
        if (build.getAction(BuildSonarAction.class) == null) {
            build.addAction((Action)new BuildSonarAction());
        }
        ArgumentListBuilder args = new ArgumentListBuilder();
        EnvVars env = build.getEnvironment((TaskListener)listener);
        env.overrideAll(build.getBuildVariables());
        SonarRunnerInstallation sri = this.getSonarRunnerInstallation();
        if (sri == null) {
            args.add(launcher.isUnix() ? "sonar-runner" : "sonar-runner.bat");
        } else {
            sri = sri.forNode(Computer.currentComputer().getNode(), (TaskListener)listener);
            String exe = (sri = sri.forEnvironment(env)).getExecutable(launcher);
            if (exe == null) {
                Logger.printFailureMessage((BuildListener)listener);
                listener.fatalError(Messages.SonarRunner_ExecutableNotFound((Object)sri.getName()));
                return false;
            }
            args.add(exe);
            env.put((Object)"SONAR_RUNNER_HOME", (Object)sri.getHome());
        }
        ExtendedArgumentListBuilder argsBuilder = new ExtendedArgumentListBuilder(args, launcher.isUnix());
        if (!this.populateConfiguration(argsBuilder, build, listener, env, this.getSonarInstallation())) {
            return false;
        }
        JDK jdkToUse = this.getJdkToUse(build.getProject());
        if (jdkToUse != null) {
            Computer computer = Computer.currentComputer();
            if (computer != null) {
                jdkToUse = jdkToUse.forNode(computer.getNode(), (TaskListener)listener);
            }
            jdkToUse.buildEnvVars((Map)env);
        }
        env.put((Object)"SONAR_RUNNER_OPTS", (Object)this.getJavaOpts());
        long startTime = System.currentTimeMillis();
        try {
            int r = launcher.launch().cmds(args).envs((Map)env).stdout((TaskListener)listener).pwd(build.getModuleRoot()).join();
            return r == 0;
        }
        catch (IOException e) {
            Logger.printFailureMessage((BuildListener)listener);
            Util.displayIOException((IOException)e, (TaskListener)listener);
            String errorMessage = Messages.SonarRunner_ExecFailed();
            if (sri == null && System.currentTimeMillis() - startTime < 1000L && this.getDescriptor().getSonarRunnerInstallations() == null) {
                errorMessage = errorMessage + Messages.SonarRunner_GlobalConfigNeeded();
            }
            e.printStackTrace(listener.fatalError(errorMessage));
            return false;
        }
    }

    public static boolean isSonarInstallationValid(String sonarInstallationName, BuildListener listener) {
        String failureMsg;
        SonarInstallation sonarInstallation = SonarInstallation.get((String)sonarInstallationName);
        if (sonarInstallation == null) {
            failureMsg = StringUtils.isBlank((String)sonarInstallationName) ? Messages.SonarPublisher_NoInstallation((Object)SonarInstallation.all().length) : Messages.SonarPublisher_NoMatchInstallation((Object)sonarInstallationName, (Object)SonarInstallation.all().length);
            failureMsg = failureMsg + "\n" + Messages.SonarPublisher_FixInstalltionTip();
        } else {
            failureMsg = sonarInstallation.isDisabled() ? Messages.SonarPublisher_InstallDisabled((Object)sonarInstallation.getName()) : null;
        }
        if (failureMsg != null) {
            Logger.printFailureMessage((BuildListener)listener);
            listener.fatalError(failureMsg);
            return false;
        }
        return true;
    }

    @VisibleForTesting
    boolean populateConfiguration(ExtendedArgumentListBuilder args, AbstractBuild build, BuildListener listener, EnvVars env, SonarInstallation si) throws IOException, InterruptedException {
        if (si != null) {
            args.append("sonar.jdbc.driver", si.getDatabaseDriver());
            args.append("sonar.jdbc.url", si.getDatabaseUrl());
            args.appendMasked("sonar.jdbc.username", si.getDatabaseLogin());
            args.appendMasked("sonar.jdbc.password", si.getDatabasePassword());
            args.append("sonar.host.url", si.getServerUrl());
            if (StringUtils.isNotBlank((String)si.getSonarLogin())) {
                args.appendMasked("sonar.login", si.getSonarLogin());
                args.appendMasked("sonar.password", si.getSonarPassword());
            }
        }
        args.append("sonar.projectBaseDir", build.getModuleRoot().getRemote());
        if (StringUtils.isNotBlank((String)this.getProject())) {
            String projectSettingsFile = env.expand(this.getProject());
            FilePath projectSettingsFilePath = build.getModuleRoot().child(projectSettingsFile);
            if (!projectSettingsFilePath.exists()) {
                FilePath projectSettingsFilePath2 = build.getWorkspace().child(projectSettingsFile);
                if (projectSettingsFilePath2.exists()) {
                    projectSettingsFilePath = projectSettingsFilePath2;
                } else {
                    listener.fatalError("Unable to find Sonar project settings at " + projectSettingsFilePath);
                    return false;
                }
            }
            args.append("project.settings", projectSettingsFilePath.getRemote());
        }
        Properties p = new Properties();
        p.load(new ByteArrayInputStream(env.expand(this.getProperties()).getBytes()));
        this.loadProperties(args, p);
        return true;
    }

    private void loadProperties(ExtendedArgumentListBuilder args, Properties p) {
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            args.append(entry.getKey().toString(), entry.getValue().toString());
        }
    }

    private JDK getJdkToUse(AbstractProject project) {
        JDK jdkToUse = this.getJDK();
        if (jdkToUse == null) {
            jdkToUse = project.getJDK();
        }
        return jdkToUse;
    }
}

