/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sonar;

import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.maven.AbstractMavenProject;
import hudson.maven.MavenModule;
import hudson.maven.MavenModuleSet;
import hudson.maven.ModuleName;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.model.JDK;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.sonar.BuildSonarAction;
import hudson.plugins.sonar.Messages;
import hudson.plugins.sonar.ProjectSonarAction;
import hudson.plugins.sonar.SonarInstallation;
import hudson.plugins.sonar.SonarRunnerBuilder;
import hudson.plugins.sonar.model.LightProjectConfig;
import hudson.plugins.sonar.model.TriggersConfig;
import hudson.plugins.sonar.utils.Logger;
import hudson.plugins.sonar.utils.SonarMaven;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Maven;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SonarPublisher
extends Notifier {
    private String jdk;
    private final String installationName;
    private String branch;
    private String language;
    private final String mavenOpts;
    private final String jobAdditionalProperties;
    private TriggersConfig triggers;
    private String mavenInstallationName;
    private String rootPom;
    @Deprecated
    public LightProjectConfig lightProject;

    public SonarPublisher(String installationName, String jobAdditionalProperties, String mavenOpts) {
        this(installationName, new TriggersConfig(), jobAdditionalProperties, mavenOpts, null, null);
    }

    public SonarPublisher(String installationName, TriggersConfig triggers, String jobAdditionalProperties, String mavenOpts) {
        this(installationName, null, null, triggers, jobAdditionalProperties, mavenOpts, null, null, null);
    }

    public SonarPublisher(String installationName, TriggersConfig triggers, String jobAdditionalProperties, String mavenOpts, String mavenInstallationName, String rootPom) {
        this(installationName, null, null, triggers, jobAdditionalProperties, mavenOpts, mavenInstallationName, rootPom, null);
    }

    public SonarPublisher(String installationName, String branch, String language, TriggersConfig triggers, String jobAdditionalProperties, String mavenOpts, String mavenInstallationName, String rootPom) {
        this(installationName, branch, language, triggers, jobAdditionalProperties, mavenOpts, mavenInstallationName, rootPom, null);
    }

    @DataBoundConstructor
    public SonarPublisher(String installationName, String branch, String language, TriggersConfig triggers, String jobAdditionalProperties, String mavenOpts, String mavenInstallationName, String rootPom, String jdk) {
        this.installationName = installationName;
        this.branch = branch;
        this.language = language;
        this.triggers = triggers;
        this.mavenOpts = mavenOpts;
        this.jobAdditionalProperties = jobAdditionalProperties;
        this.mavenInstallationName = mavenInstallationName;
        this.rootPom = rootPom;
        this.jdk = jdk;
    }

    public JDK getJDK() {
        return Hudson.getInstance().getJDK(this.jdk);
    }

    public String getInstallationName() {
        return this.installationName;
    }

    public String getMavenOpts() {
        return this.mavenOpts;
    }

    public String getJobAdditionalProperties() {
        return StringUtils.trimToEmpty((String)this.jobAdditionalProperties);
    }

    public boolean isUseGlobalTriggers() {
        return this.triggers == null;
    }

    public boolean isUseLocalTriggers() {
        return !this.isUseGlobalTriggers();
    }

    public String getBranch() {
        return this.branch;
    }

    public String getLanguage() {
        return StringUtils.trimToEmpty((String)this.language);
    }

    public TriggersConfig getTriggers() {
        return this.triggers;
    }

    public String getMavenInstallationName() {
        return this.mavenInstallationName;
    }

    public String getRootPom() {
        return StringUtils.trimToEmpty((String)this.rootPom);
    }

    public static boolean isMavenBuilder(AbstractProject currentProject) {
        return currentProject instanceof MavenModuleSet;
    }

    public SonarInstallation getInstallation() {
        return SonarInstallation.get(this.getInstallationName());
    }

    private boolean isSkip(AbstractBuild<?, ?> build, BuildListener listener, SonarInstallation sonarInstallation) throws IOException, InterruptedException {
        String skipLaunchMsg = this.isUseGlobalTriggers() ? sonarInstallation.getTriggers().isSkipSonar(build, listener) : this.getTriggers().isSkipSonar(build, listener);
        if (skipLaunchMsg != null) {
            listener.getLogger().println(skipLaunchMsg);
            return true;
        }
        return false;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        if (!SonarRunnerBuilder.isSonarInstallationValid(this.getInstallationName(), listener)) {
            return false;
        }
        SonarInstallation sonarInstallation = this.getInstallation();
        if (this.isSkip(build, listener, sonarInstallation)) {
            return true;
        }
        build.addAction((Action)new BuildSonarAction());
        boolean sonarSuccess = this.executeSonar(build, launcher, listener, sonarInstallation);
        if (!sonarSuccess) {
            build.setResult(Result.FAILURE);
        }
        listener.getLogger().println("Sonar analysis completed: " + build.getResult());
        return sonarSuccess;
    }

    public MavenModuleSet getMavenProject(AbstractBuild build) {
        return build.getProject() instanceof MavenModuleSet ? (MavenModuleSet)build.getProject() : null;
    }

    private String getPomName(AbstractBuild<?, ?> build) {
        MavenModuleSet mavenModuleProject = this.getMavenProject(build);
        String pomName = mavenModuleProject != null ? mavenModuleProject.getRootPOM() : this.getRootPom();
        if (StringUtils.isEmpty((String)pomName)) {
            pomName = "pom.xml";
        }
        return pomName;
    }

    private boolean executeSonar(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener, SonarInstallation sonarInstallation) {
        try {
            MavenModuleSet mavenModuleSet;
            String pomName = this.getPomName(build);
            String mavenInstallationName = this.getMavenInstallationName();
            if (SonarPublisher.isMavenBuilder(build.getProject()) && null != (mavenModuleSet = this.getMavenProject(build)).getMaven().getName()) {
                mavenInstallationName = mavenModuleSet.getMaven().getName();
            }
            return SonarMaven.executeMaven(build, launcher, listener, mavenInstallationName, pomName, sonarInstallation, this, this.getJDK());
        }
        catch (IOException e) {
            Logger.printFailureMessage(listener);
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError("command execution failed"));
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (Exception e) {
            Logger.printFailureMessage(listener);
            e.printStackTrace(listener.fatalError("command execution failed"));
            return false;
        }
    }

    protected String getSonarUrl(AbstractProject<?, ?> project) {
        MavenModuleSet mms;
        MavenModule rootModule;
        AbstractMavenProject mavenProject;
        SonarInstallation sonarInstallation = this.getInstallation();
        if (sonarInstallation == null) {
            return null;
        }
        String url = sonarInstallation.getServerLink();
        if (project instanceof AbstractMavenProject && (mavenProject = (AbstractMavenProject)project).getRootProject() instanceof MavenModuleSet && (rootModule = (mms = (MavenModuleSet)mavenProject.getRootProject()).getRootModule()) != null) {
            ModuleName moduleName = rootModule.getModuleName();
            url = sonarInstallation.getProjectLink(moduleName.groupId, moduleName.artifactId, this.getBranch());
        }
        try {
            AbstractBuild lastBuild = (AbstractBuild)project.getLastBuild();
            if (lastBuild != null) {
                MavenXpp3Reader reader = new MavenXpp3Reader();
                Model model = reader.read((Reader)new InputStreamReader(lastBuild.getWorkspace().child(this.getPomName(lastBuild)).read()));
                String groupId = model.getGroupId();
                String artifactId = model.getArtifactId();
                url = sonarInstallation.getProjectLink(groupId, artifactId, this.getBranch());
            }
        }
        catch (IOException e) {
        }
        catch (XmlPullParserException e) {
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        return url;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new ProjectSonarAction(this.getSonarUrl(project));
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension(ordinal=1000.0)
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private volatile SonarInstallation[] installations = new SonarInstallation[0];

        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "Sonar";
        }

        public String getHelpFile() {
            return "/plugin/sonar/help.html";
        }

        public SonarInstallation[] getInstallations() {
            return this.installations;
        }

        public void setInstallations(SonarInstallation ... installations) {
            this.installations = installations;
            this.save();
        }

        public Maven.MavenInstallation[] getMavenInstallations() {
            return ((Maven.DescriptorImpl)Hudson.getInstance().getDescriptorByType(Maven.DescriptorImpl.class)).getInstallations();
        }

        public boolean configure(StaplerRequest req, JSONObject json) {
            List list = req.bindJSONToList(SonarInstallation.class, json.get("inst"));
            this.setInstallations(list.toArray(new SonarInstallation[list.size()]));
            return true;
        }

        public FormValidation doCheckMandatory(@QueryParameter String value) {
            return StringUtils.isBlank((String)value) ? FormValidation.error((String)Messages.SonarPublisher_MandatoryProperty()) : FormValidation.ok();
        }

        public FormValidation doCheckMandatoryAndNoSpaces(@QueryParameter String value) {
            return StringUtils.isBlank((String)value) || value.contains(" ") ? FormValidation.error((String)Messages.SonarPublisher_MandatoryPropertySpaces()) : FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

