/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sonar;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.model.JDK;
import hudson.model.TaskListener;
import hudson.plugins.sonar.BuildSonarAction;
import hudson.plugins.sonar.Messages;
import hudson.plugins.sonar.SonarInstallation;
import hudson.plugins.sonar.SonarRunnerInstallation;
import hudson.plugins.sonar.utils.ExtendedArgumentListBuilder;
import hudson.plugins.sonar.utils.Logger;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import hudson.util.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class SonarRunnerBuilder
extends Builder {
    private final String installationName;
    private final String project;
    private final String properties;
    private final String javaOpts;
    private String jdk;
    private final String sonarRunnerName;

    @Deprecated
    public SonarRunnerBuilder(String installationName, String project, String properties, String javaOpts) {
        this(installationName, null, project, properties, javaOpts, null);
    }

    @Deprecated
    public SonarRunnerBuilder(String installationName, String sonarRunnerName, String project, String properties, String javaOpts) {
        this(installationName, sonarRunnerName, project, properties, javaOpts, null);
    }

    @DataBoundConstructor
    public SonarRunnerBuilder(String installationName, String sonarRunnerName, String project, String properties, String javaOpts, String jdk) {
        this.installationName = installationName;
        this.sonarRunnerName = sonarRunnerName;
        this.javaOpts = javaOpts;
        this.project = project;
        this.properties = properties;
        this.jdk = jdk;
    }

    public String getInstallationName() {
        return Util.fixNull((String)this.installationName);
    }

    public String getSonarRunnerName() {
        return Util.fixNull((String)this.sonarRunnerName);
    }

    public JDK getJDK() {
        return Hudson.getInstance().getJDK(this.jdk);
    }

    public String getProject() {
        return Util.fixNull((String)this.project);
    }

    public String getProperties() {
        return Util.fixNull((String)this.properties);
    }

    public String getJavaOpts() {
        return Util.fixNull((String)this.javaOpts);
    }

    public SonarInstallation getSonarInstallation() {
        return SonarInstallation.get(this.getInstallationName());
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public SonarRunnerInstallation getSonarRunnerInstallation() {
        for (SonarRunnerInstallation sri : this.getDescriptor().getSonarRunnerInstallations()) {
            if (this.sonarRunnerName == null || !this.sonarRunnerName.equals(sri.getName())) continue;
            return sri;
        }
        if (this.getDescriptor().getSonarRunnerInstallations().length > 0) {
            return this.getDescriptor().getSonarRunnerInstallations()[0];
        }
        return null;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        if (!SonarRunnerBuilder.isSonarInstallationValid(this.getInstallationName(), listener)) {
            return false;
        }
        if (build.getAction(BuildSonarAction.class) == null) {
            build.addAction((Action)new BuildSonarAction());
        }
        ArgumentListBuilder args = new ArgumentListBuilder();
        EnvVars env = build.getEnvironment((TaskListener)listener);
        env.overrideAll(build.getBuildVariables());
        SonarRunnerInstallation sri = this.getSonarRunnerInstallation();
        if (sri == null) {
            args.add(launcher.isUnix() ? "sonar-runner" : "sonar-runner.bat");
        } else {
            sri = sri.forNode(Computer.currentComputer().getNode(), (TaskListener)listener);
            String exe = (sri = sri.forEnvironment(env)).getExecutable(launcher);
            if (exe == null) {
                Logger.printFailureMessage(listener);
                listener.fatalError(Messages.SonarRunner_ExecutableNotFound(sri.getName()));
                return false;
            }
            args.add(exe);
            env.put((Object)"SONAR_RUNNER_HOME", (Object)sri.getHome());
        }
        ExtendedArgumentListBuilder argsBuilder = new ExtendedArgumentListBuilder(args, launcher.isUnix());
        this.populateConfiguration(argsBuilder, build.getWorkspace().getRemote(), env);
        JDK jdkToUse = this.getJdkToUse(build.getProject());
        if (jdkToUse != null) {
            Computer computer = Computer.currentComputer();
            if (computer != null) {
                jdkToUse = jdkToUse.forNode(computer.getNode(), (TaskListener)listener);
            }
            jdkToUse.buildEnvVars((Map)env);
        }
        env.put((Object)"SONAR_RUNNER_OPTS", (Object)this.getJavaOpts());
        long startTime = System.currentTimeMillis();
        try {
            int r = launcher.launch().cmds(args).envs((Map)env).stdout((TaskListener)listener).pwd(build.getWorkspace()).join();
            return r == 0;
        }
        catch (IOException e) {
            Logger.printFailureMessage(listener);
            Util.displayIOException((IOException)e, (TaskListener)listener);
            String errorMessage = Messages.SonarRunner_ExecFailed();
            if (sri == null && System.currentTimeMillis() - startTime < 1000L && this.getDescriptor().getSonarRunnerInstallations() == null) {
                errorMessage = errorMessage + Messages.SonarRunner_GlobalConfigNeeded();
            }
            e.printStackTrace(listener.fatalError(errorMessage));
            return false;
        }
    }

    public static boolean isSonarInstallationValid(String sonarInstallationName, BuildListener listener) {
        String failureMsg;
        SonarInstallation sonarInstallation = SonarInstallation.get(sonarInstallationName);
        if (sonarInstallation == null) {
            failureMsg = StringUtils.isBlank((String)sonarInstallationName) ? Messages.SonarPublisher_NoInstallation(SonarInstallation.all().length) : Messages.SonarPublisher_NoMatchInstallation(sonarInstallationName, SonarInstallation.all().length);
            failureMsg = failureMsg + "\n" + Messages.SonarPublisher_FixInstalltionTip();
        } else {
            failureMsg = sonarInstallation.isDisabled() ? Messages.SonarPublisher_InstallDisabled(sonarInstallation.getName()) : null;
        }
        if (failureMsg != null) {
            Logger.printFailureMessage(listener);
            listener.fatalError(failureMsg);
            return false;
        }
        return true;
    }

    private void populateConfiguration(ExtendedArgumentListBuilder args, String projectBaseDir, EnvVars env) throws IOException {
        SonarInstallation si = this.getSonarInstallation();
        if (si != null) {
            args.append("sonar.jdbc.driver", si.getDatabaseDriver());
            args.append("sonar.jdbc.url", si.getDatabaseUrl());
            args.appendMasked("sonar.jdbc.username", si.getDatabaseLogin());
            args.appendMasked("sonar.jdbc.password", si.getDatabasePassword());
            args.append("sonar.host.url", si.getServerUrl());
        }
        args.append("sonar.projectBaseDir", projectBaseDir);
        if (StringUtils.isNotBlank((String)this.getProject())) {
            File projectSettings = new File(this.getProject());
            Properties p = this.toProperties(projectSettings);
            this.loadProperties(args, p);
        }
        Properties p = new Properties();
        p.load(new ByteArrayInputStream(env.expand(this.getProperties()).getBytes()));
        this.loadProperties(args, p);
    }

    private void loadProperties(ExtendedArgumentListBuilder args, Properties p) {
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            args.append(entry.getKey().toString(), entry.getValue().toString());
        }
    }

    private Properties toProperties(File file) {
        Properties properties;
        FileInputStream in = null;
        Properties props = new Properties();
        try {
            in = new FileInputStream(file);
            props.load(in);
            properties = props;
        }
        catch (Exception e) {
            try {
                throw new IllegalStateException("Fail to load file: " + file.getAbsolutePath(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        return properties;
    }

    private JDK getJdkToUse(AbstractProject project) {
        JDK jdkToUse = this.getJDK();
        if (jdkToUse == null) {
            jdkToUse = project.getJDK();
        }
        return jdkToUse;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public SonarInstallation[] getSonarInstallations() {
            return SonarInstallation.all();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return Messages.SonarRunnerBuilder_DisplayName();
        }

        public SonarRunnerInstallation[] getSonarRunnerInstallations() {
            return ((SonarRunnerInstallation.DescriptorImpl)Hudson.getInstance().getDescriptorByType(SonarRunnerInstallation.DescriptorImpl.class)).getInstallations();
        }
    }
}

